CREATE OR REPLACE VIEW vw_bill AS 
SELECT 
    bm.*, 
    IFNULL(pd.total_payment_amt, 0) AS total_pay, 
    (IFNULL(bm.ttl_bill_amt, 0) - IFNULL(pd.total_payment_amt, 0)) AS due_amount
FROM bill_mst AS bm
LEFT JOIN (
    SELECT 
        d.bill_num, 
        SUM(IFNULL(p.payment_amt, 0)) AS total_payment_amt
    FROM bill_dtl AS d
    JOIN event_payment AS p ON d.event_id = p.event_id
    WHERE p.invoice > 0
    GROUP BY d.bill_num
) AS pd ON bm.bill_num = pd.bill_num;