<?php
$_page_title = "Package";
$_main_root = '../';
require_once $_main_root . 'db/model.php';

$db = new Model();
if (isset($_POST['type'])) {
    if ($_POST['type'] == "list") {
        $list = $db->GetPackage(0, false);
        header('Content-Type: application/json');
        echo json_encode($list);
    }

    if ($_POST['type'] == 'detailsList') {
        $list = $db->GetPackageDetails($_POST['package_id'], true);
        header('Content-Type: application/json');
        echo json_encode($list);
    }

    exit;
}

include($_main_root . 'content/shared/header.php');
?>

<style>
    #dataTable tbody td:nth-child(2),
    #dataTable tbody td:nth-child(3),
    #dataTable tbody td:nth-child(4) {
        text-align: end;
    }
</style>

<!-- modal -->
<div id="modalDiv"></div>

<div class="container container-fluid">
    <div class="my-4 d-flex justify-content-between align-items-center">
        <h2 style="color:var(--s-text-color);">PACKAGE LIST</h2>
        <div>
            <?php if ($db->sAccess("discount", "view")) { ?>
                <a href="discount.php" class="btn btn-sm btn-outline-info ms-3"><i class="bi bi-percent me-2"></i>DISCOUNT</a>
            <?php } ?>
            <?php if ($db->sAccess("package_details", "view")) { ?>
                <a href="package_details.php" class="btn btn-sm btn-outline-info"><i class="bi bi-list me-2"></i> PACKAGEDETAILS</a>
            <?php } ?>
            <?php if ($sa) { ?>
                <button class="btn btn-sm btn-outline-info" onclick="DetailPackage(0)">
                    <i class="bi bi-plus-circle me-2"></i> NEW PACKAGE
                </button>
            <?php } ?>
        </div>
    </div>

    <div class="row my-4">
        <div class="table-responsive-lg">
            <table id="dataTable" class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">
                <thead style="color:var(--s-text-color);" class="mt-3">
                    <th class="">Package Name</th>
                    <th style="width: 80px;">Amount</th>
                    <th style="width: 80px;">Discount</th>
                    <th style="width: 80px;">After Disc.</th>
                    <th style="width: 80px;">Status</th>
                    <th style="width: 50px;">Action</th>
                </thead>
                <tbody>
                </tbody>
            </table>

        </div>
    </div>
</div>

<?php $s_scripts = ['package']; ?>
<?php include($_main_root . 'content/shared/footer.php'); ?>