$(document).ready(function () {
    EmpLedger();
});

function setActiveButton(activeId) {
    const buttons = ['empLedgerBtn', 'empBillBtn', 'assignedEmpBtn'];
    buttons.forEach(id => {
        const btn = document.getElementById(id);
        if (id === activeId) {
            btn.classList.remove("btn-outline-success");
            btn.classList.add("btn-success");
        } else {
            btn.classList.remove("btn-success");
            btn.classList.add("btn-outline-success");
        }
    });
}


function AssignEmpEvent() {
    setActiveButton("assignedEmpBtn");
    $('#reportTitle').html('Assigned Employee Event');

    var btn = ``;
    $('#right-btn-section').html(btn);

    $("#reportBody").html('');

    $.ajax({
        type: "post",
        url: "report_assign_emp_event.php",
        success: function (response) {
            $("#reportBody").append(response);
        }
    });
}

function EmpLedger() {
    setActiveButton("empLedgerBtn");
    $('#reportTitle').html('Employee Ledger');

    var btn = `<button id="printButtonEmpLedger" class="btn btn-sm btn-outline-secondary"><i class="bi bi-printer-fill"></i></button>`;
    $('#right-btn-section').html(btn);

    $("#reportBody").html('');

    $.ajax({
        type: "post",
        url: "report_emp_ledger.php",
        success: function (response) {
            $("#reportBody").append(response);
        }
    });
}

function EmpBill() {
    setActiveButton("empBillBtn");
    $('#reportTitle').html('Employee Bill | Month Wise');

    var btn = `<button id="printBtnEmpBill" class="btn btn-sm btn-outline-secondary"><i class="bi bi-printer-fill"></i></button>`;
    $('#right-btn-section').html(btn);

    $("#reportBody").html('');

    $.ajax({
        type: "post",
        url: "report_emp_bill.php",
        success: function (response) {
            $("#reportBody").append(response);
        }
    });
}