<?php
$_main_root = '../';
require_once $_main_root . 'db/model.php';

$db = new Model();
if (isset($_POST['type'])) {
    header('Content-Type: application/json');

    if ($_POST['type'] == "list") {
        $list = $db->GetBillMst();
        echo json_encode($list);
    }

    exit;
}

?>

<div class="table-responsive">
    <table id="tableQuote" class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">
        <thead style="color:var(--s-text-color);" class="mt-3">
            <th style="width: 100px;">Bill Num</th>
            <th style="">Biller Name</th>
            <th style="width: 80px;">Bill Amt</th>
            <th style="width: 80px;">Discount</th>
            <th style="width: 80px;">Total Bill</th>
            <th style="width: 80px;">Total Pay</th>
            <th style="width: 80px;">Due Amt</th>
            <th style="width: 120px;">Action</th>
        </thead>
        <tbody></tbody>
    </table>
</div>

<script>
    $(document).ready(function () {
        table = $('#tableQuote').DataTable({
            order: [0, 'desc'],
            ajax: {
                url: 'cust_bill_list_all.php',
                type: 'POST',
                data: {
                    type: 'list'
                },
                dataSrc: function (json) {
                    return json;
                },
            },
            columns: [
                { data: 'bill_num' },
                { data: 'name' },
                { data: 'bill_amt' },
                { data: 'discount' },
                { data: 'ttl_bill_amt' },
                { data: 'total_pay' },
                { data: 'due_amount' },
                {
                    data: null,
                    render: function (data, type, row) {
                        var btn = `<div class="btn-group">
                        <button onclick="sPrint('bill', ${row.bill_num})" class="btn btn-sm action-btn" title="Print Bill"><i class="bi bi-printer-fill"></i> Bill</button>
                        <button onclick="sPrint('eventConfirmation', ${row.bill_num})" class="btn btn-sm action-btn" title="Print Confirmation"><i class="bi bi-printer-fill"></i> Confirm</button>
                        </div>`;
                        return btn;
                    }
                }
            ],
            columnDefs: [
                { targets: 0, className: 'dt-center' },
                { targets: 2, className: 'dt-right' },
                { targets: 3, className: 'dt-right' },
                { targets: 4, className: 'dt-right' },
                { targets: 5, className: 'dt-right' },
                { targets: 6, className: 'dt-right' },
                { targets: 7, className: 'dt-center' },
            ]
        });
    });
</script>