<?php
$s_script = "";

if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

if (!class_exists('User')) {
    include($_main_root . 'config/enum.php');
}

if (!isset($_login_page) || !$_login_page) {

    if (!User::Login()) {
        header("Location: " . $_main_root . "index.php");
        exit();
    }
}

if (!class_exists("Config")) {
    include($_main_root . 'config/config.php');
}


require_once $_main_root . 'db/model.php';
$db = new Model();


$currentPage = basename($_SERVER['PHP_SELF'], '.php');
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" sizes="32x32" type="image/png" href="<?= BASE_URL . 'img/favicon.png' ?>">

    <?php if (basename($_SERVER['PHP_SELF']) == 'book_us.php') { ?>
        <!-- Open Graph Meta Tags for Booking Page -->
        <meta property="og:title" content="Book Us | Snap Moment Photography" />
        <meta property="og:description"
            content="Reserve your next photoshoot with Snap Moment Photography. Fast booking, professional service, and beautiful memories!" />
        <meta property="og:image" content="<?= BASE_URL . 'img/Book-Now-Photo.jpg' ?>" />
        <meta property="og:image:width" content="1200" />
        <meta property="og:image:height" content="630" />
        <meta property="og:url" content="book_us.php" />
        <meta property="og:type" content="website" />
        <meta property="og:site_name" content="Snap Moment Photography" />

        <!-- Twitter Card Support -->
        <meta name="twitter:card" content="summary_large_image">
        <meta name="twitter:title" content="Book Your Photoshoot | Snap Moment Photography">
        <meta name="twitter:description" content="Reserve your next photoshoot today with Snap Moment Photography.">
        <meta name="twitter:image" content="<?= BASE_URL . 'img/Book-Now-Photo.jpg' ?>">
    <?php } ?>

    <link rel="stylesheet" href="<?php echo ($_main_root . 'vendor/select2-4.0.13/css/select2.min.css'); ?>">
    <link rel="stylesheet" href="<?php echo ($_main_root . 'vendor/bootstrap-5.3.0/css/bootstrap.min.css'); ?>">
    <link rel="stylesheet"
        href="<?php echo ($_main_root . 'vendor/bootstrap-icons-1.10.5/font/bootstrap-icons.css'); ?>">
    <link rel="stylesheet" href="<?php echo ($_main_root . 'vendor/DataTables/datatables.min.css'); ?>">
    <link rel="stylesheet" href="<?php echo ($_main_root . 'vendor/datetimepicker/jquery.datetimepicker.min.css'); ?>">
    <link rel="stylesheet" href="<?php echo ($_main_root . 'style/custom.css'); ?>">
    <title>
        <?php echo ($_page_title); ?>
    </title>
</head>

<body>
    <nav class="navbar sticky-top navbar-expand-xl navbar-dark bg-dark">
        <div class="container">
            <?php
            if (User::Login()) {
                include 'menu_main.php';
            } else {
                if ($_public_form) {
                    include 'menu_public.php';
                }
            }
            ?>
        </div>
    </nav>

    <?php
    if (User::Login()) {
        require_once $_main_root . 'config/access.php';
    }
    ?>