<?php
$_page_title = "User Profile";
$_main_root = '../';
include($_main_root . 'content/shared/header.php');

$username = User::UserName();
$user = $db->GetUser($username, "un");
?>

<!-- modal -->
<div id="modalDiv"></div>

<div class="container container-fluid">
    <div class="my-4 text-center">
        <h2 style="color:var(--s-text-color);">USER PROFILE</h2>
    </div>
    <div class="row my-4">
        <div class="col-12 col-md-4">
            <div class="col-12 p-2 pt-4 pb-4 rounded" style="background-color:var(--s-background-color-2); border: 1px solid var(--s-text-color);">
                <div class="text-center">
                    <img src="<?php echo $_userProfileImage; ?>" alt="" width="150" height="150" class="rounded-circle border">
                </div>
                <div class="text-center mt-3" style="color: var(--s-text-color-silver);">
                    <h3 class="fw-500"><?php echo $user["full_name"]; ?></h3>
                    <p style="color:var(--s-text-color)"><?= $user["role_name"] ?></p>
                </div>
            </div>
        </div>
        <div class="col-12 col-md-8 mt-3 mt-md-0">
            <div class="col-12 p-2 rounded" style="background-color:var(--s-background-color-2); border: 1px solid var(--s-text-color);">
                <table class="table" style="color: var(--s-text-color-silver);">
                    <tr style="border-color: var(--s-text-color-2);">
                        <td class="w-25">Full Name</td>
                        <td class="w-100"><?php echo $user["full_name"]; ?></td>
                    </tr>
                    <tr style="border-color: var(--s-text-color-2);">
                        <td class="w-25">User Name</td>
                        <td class="w-100"><?php echo $user["username"]; ?></td>
                    </tr>
                    <tr style="border-color: var(--s-text-color-2);">
                        <td class="w-25">Register Date</td>
                        <td class="w-100"><?php echo sDate($user["create_at"]); ?></td>
                    </tr>
                    <tr class="text-center">
                        <td class="pt-5 border-0 space-between" colspan=2>
                            <button class="btn btn-sm action-btn-1" onclick="PassModal(<?php echo $user['id']; ?>)">Change Password</button>
                            <button class="btn btn-sm action-btn-1" onclick="ProfileModal(<?php echo $user['id']; ?>)">Update Profile</button>
                        </td>
                    </tr>

                </table>
            </div>
        </div>
    </div>
</div>

<?php $s_scripts = ['profile']; ?>
<?php include($_main_root . 'content/shared/footer.php'); ?>