$(document).ready(function () {
    var roleId = $("#role_id").val();
    $("#selected_role_id").val(roleId);
    LoadPermission(roleId);

    $("#role_id").on("change", function () {
        var id = $(this).val();
        $("#selected_role_id").val(id);
        LoadPermission(id);
    });

    function LoadPermission(id) {
        $(".action-check").prop("checked", false); // clear all

        $.ajax({
            type: "POST",
            url: "role_permission.php",
            data: { type: 'rp', id: id },
            dataType: "json",
            success: function (response) {
                response.forEach(p => {
                    if (p.view == 1) $("input[name='view_" + p.id + "']").prop("checked", true);
                    if (p.add == 1) $("input[name='add_" + p.id + "']").prop("checked", true);
                    if (p.edit == 1) $("input[name='edit_" + p.id + "']").prop("checked", true);
                    if (p.delete == 1) $("input[name='delete_" + p.id + "']").prop("checked", true);

                    if (p.url == null || p.url == '') {
                        $("input[name='add_" + p.id + "']").prop("disabled", true);
                        $("input[name='edit_" + p.id + "']").prop("disabled", true);
                        $("input[name='delete_" + p.id + "']").prop("disabled", true);
                    }

                    if (p.id == 3 || p.id == 5 || p.id == 6 || p.id == 8 || p.id == 16 || p.id == 17 || p.id == 18 || p.id == 22 || p.id == 25) { 
                        $("input[name='add_" + p.id + "']").prop("disabled", true) 
                    };

                    if (p.id == 1 || p.id == 3 || p.id == 5 || p.id == 6 || p.id == 16 || p.id == 17 || p.id == 18 || p.id == 21 || p.id == 22 || p.id == 25) { 
                        $("input[name='edit_" + p.id + "']").prop("disabled", true) 
                    };

                    if (p.id == 3 || p.id == 5 || p.id == 6 || p.id == 8 || p.id == 9 || p.id == 10 || p.id == 11 || p.id == 12 || p.id == 13 || p.id == 16 || p.id == 17 || p.id == 20 || p.id == 22 || p.id == 24 || p.id == 25) { 
                        $("input[name='delete_" + p.id + "']").prop("disabled", true) 
                    };
                });
            }
        });
    }

    // Save form
    $("#permissionForm").on("submit", function (e) {
        e.preventDefault();

        sAlertConfirm(() => {
            $.ajax({
                url: "role_permission.php",
                method: "POST",
                data: $(this).serialize(),
                success: function (response) {
                    try {
                        let res = JSON.parse(response);
                        if (res.success) {
                            sAlert(res.message);
                        } else {
                            sAlert("Failed to save permissions!", "", "error");
                        }
                    } catch (e) {
                        console.error("Invalid response:", response);
                    }
                }
            });
        }, "update");
    });

});