function PassModal(id) {
  $.ajax({
    type: "post",
    url: "modal_password.php",
    data: {
      type: "",
      id: id,
    },
    success: function (sData) {
      $("#modalDiv").html("");
      $("#modalDiv").append(sData);
      $("#passModal").modal("show");
    },
  });
}

function ProfileModal(id) {
    $.ajax({
      type: "post",
      url: "modal_profile.php",
      data: {
        type: "",
        id: id,
      },
      success: function (sData) {
        $("#modalDiv").html("");
        $("#modalDiv").append(sData);
        $("#profileModal").modal("show");
      },
    });
  }

function UpdateUser() {
  var id = $("#mId").val();
  var fullName = $("#mFullName").val();
  var profilePhoto = $("#mProfilePhoto")[0].files[0];  // Get the file

  // Validate full name
  if (fullName === "" || fullName === null) {
    $("#mFullName").css("border-color", "red");
    return;
  }

  // Prepare form data
  var formData = new FormData();
  formData.append("type", "up");
  formData.append("id", id);
  formData.append("fullName", fullName);
  if (profilePhoto) {
    formData.append("profilePhoto", profilePhoto);
  }

  swal({
    title: "Are you sure?",
    text: "Update your profile details!",
    icon: "warning",
    buttons: true,
    dangerMode: true,
  }).then((willUpdate) => {
    if (willUpdate) {
      $.ajax({
        type: "POST",
        url: "modal_profile.php",
        data: formData,
        contentType: false,
        processData: false, // Disable automatic data processing
        success: function (response) {
          switch (response) {
            case "invalid":
              swal({
                title: "User information is not valid!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
              });
              break;
            case "photo_error":
              swal({
                title: "There was an error uploading the photo!",
                icon: "error",
                buttons: true,
                dangerMode: true,
              });
              break;
            default:
              $("#profileModal").modal("hide");
              swal("Profile updated successfully!", {
                icon: "success",
              });
              break;
          }
        },
        error: function () {
          swal({
            title: "An error occurred while updating your profile.",
            icon: "error",
            buttons: true,
            dangerMode: true,
          });
        },
      });
    }
  });
}

function UpdatePass() {
  var id = $("#mId").val();
  var currentPassword = $("#currentPassword").val();
  var newPassword = $("#newPassword").val();
  var confirmNewPassword = $("#confirmNewPassword").val();

  if (currentPassword === "" || currentPassword === null) {
    $("#currentPassword").css("border-color", "red");
    return;
  }

  if (newPassword === "" || newPassword === null) {
    $("#newPassword").css("border-color", "red");
    return;
  }

  if (confirmNewPassword === "" || confirmNewPassword === null) {
    $("#confirmNewPassword").css("border-color", "red");
    return;
  }

  if (newPassword !== confirmNewPassword) {
    swal("Passwords do not match!", {
      icon: "error",
    });
    $("#confirmNewPassword").css("border-color", "red");
    return;
  }

  swal({
    title: "Are you sure?",
    text: "Update your password!",
    icon: "warning",
    buttons: true,
    dangerMode: true,
  }).then((willDelete) => {
    if (willDelete) {
      $.ajax({
        type: "post",
        url: "modal_password.php",
        data: {
          type: "up",
          id: id,
          currentPassword: currentPassword,
          newPassword: newPassword,
        },
        success: function (sData) {
          switch (sData) {
            case "cpi":
              swal({
                title: "Your current password is incorrect!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
              });
              $("#currentPassword").css("border-color", "red");
              break;
            case "unv":
              swal({
                title: "User information not valid!",
                icon: "warning",
                buttons: true,
                dangerMode: true,
              });
              break;
            default:
              $("#passModal").modal("hide");

              swal("Successfully updated!", {
                icon: "success",
              });
              break;
          }
        },
      });
    }
  });
}

function TogglePassword(PasswordFieldId, IconId) {
  var passField = document.getElementById(PasswordFieldId);
  var icon = document.getElementById(IconId);
  if (passField.type === "password") {
    passField.type = "text";
    icon.innerHTML = '<i class="bi bi-eye"></i>';
  } else {
    passField.type = "password";
    icon.innerHTML = '<i class="bi bi-eye-slash"></i>';
  }
}

function PreviewImage(event) {
  var file = event.target.files[0];
  var image = document.getElementById('profileImage');
  
  if (file) {
      var reader = new FileReader();

      reader.onload = function(e) {
          image.src = e.target.result;
      }

      reader.readAsDataURL(file);
  } else {
      image.src = image.dataset.src;
  }
}