$(document).ready(function () {
  table = $('#dataTable').DataTable({
    order: [],
    ajax: {
      url: 'addons.php',
      type: 'POST',
      data: {
        type: 'list'
      },
      dataSrc: function (json) {
        return json;
      },
    },
    columns: [
      {
        data: 'name_qty',
      },
      { data: 'amt' },
      {
        data: null,
        render: function (data) {
          return sStatus(data['status']);
        }
      },
      {
        data: null,
        render: function (data, type, row) {
          var btn = '<div class="text-center"><div class="btn-group">';
          btn += '<button type="button" class="btn btn-sm action-btn" onclick="DetailAddOns(' + row.id + ')"><i class="bi bi-pencil-fill"></i></button>';
          btn += '</div></div>';
          return btn;
        }
      }
    ]
  });
});

function DetailAddOns(id) {
  $.ajax({
    type: "post",
    url: "modal_addons.php",
    data: {
      id: id,
    },
    success: function (sData) {
      $("#modalDiv").html("");
      $("#modalDiv").append(sData);
      $("#modalModal").modal("show");
    },
  });
}

function AddAddOns() {
  var desig = $("#desig").val();
  var name = $("#name").val();
  var qty = $("#qty").val();
  var amount = $("#amount").val();
  var status = document.getElementById('statusActive').checked ? 1 : 0;

  if (name === "" || name === null) {
    $("#name").css("border-color", "red");
    return;
  }

  if (amount === "" || amount === null || amount < 0) {
    $("#amount").css("border-color", "red");
    return;
  }

  $.ajax({
    type: "post",
    url: "modal_addons.php",
    data: {
      type: "add",
      desig: desig,
      name: name,
      qty: qty,
      amount: amount,
      status: status
    },
    success: function (response) {
      if (response.success) {
        $("#modalModal").modal("hide");
        table.ajax.reload();
        swal(response.message, {
          icon: "success",
        });
      } else {
        swal('Error: ' + response.message, {
          icon: "error",
        });
      }
    },
  });
}

function UpdateAddOns() {
  var id = $("#id").val();
  var desig = $("#desig").val();
  var name = $("#name").val();
  var qty = $("#qty").val();
  var amount = $("#amount").val();
  var status = document.getElementById('statusActive').checked ? 1 : 0;

  if (name === "" || name === null) {
    $("#name").css("border-color", "red");
    return;
  }

  if (amount === "" || amount === null || amount < 0) {
    $("#amount").css("border-color", "red");
    return;
  }

  swal({
    title: "Are you sure?",
    text: "Update this ADD-ONS!",
    icon: "warning",
    buttons: true,
    dangerMode: true,
  }).then((willDelete) => {
    if (willDelete) {
      $.ajax({
        type: "post",
        url: "modal_addons.php",
        data: {
          type: "update",
          id: id,
          desig: desig,
          name: name,
          qty: qty,
          amount: amount,
          status: status
        },
        success: function (response) {
          if (response.success) {
            $("#modalModal").modal("hide");
            table.ajax.reload();
            swal(response.message, {
              icon: "success",
            });
          } else {
            swal('Error: ' + response.message, {
              icon: "error",
            });
          }
        },
      });
    }
  });
}