<?php
include("../config/config.php");
include("../db/model.php");
$db = new Model();

$mst = null;
$dtl = null;
$pay = 0;

if (isset($_POST['billNum'])) {
	$billNumber = (int) $_POST['billNum'];
	$mst = $db->GetBillMst(false, $billNumber);
	$dtl = $db->GetBillDtlByBillNumber($billNumber);
	$pay = $db->GetBillPayByBillNum($billNumber, false, false, true);

	$bill = (float) $mst["bill_amt"];
	$discount = (float) $mst["discount"];
	$ttl_bill = (float) $mst["ttl_bill_amt"];

	$due = $ttl_bill - $pay;
}
?>

<!DOCTYPE html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<link rel="stylesheet" href="<?php echo BASE_URL; ?>style/download.css">

	<title><?= strtoupper($mst['name']) . "_Booking Confirmation"; ?></title>

</head>

<body>

	<div class="s-m-5">

		<div class="s-row s-mb-5">
			<div class="s-center">
				<img src="<?= BASE_URL ?>print/logo_black.png" height="40" />
			</div>
		</div>

		<div class="s-row s-center s-pt-5">
			<span class="s-fs-4 s-bold">EVENT CONFIRMATION</span>
			<hr class="w-50">
		</div>
		<div class="s-row s-mt-5">
			<div>Dear <span class="s-bold"><?= $mst["name"] ?></span>,</div>
			<div>We are delighted to confirm your <?= (count($dtl) > 1) ? 'multiple bookings' : 'booking' ?> with
				<strong>Snap Moment</strong> Please find the event details and payment information below:
			</div>
		</div>

		<!-- Details -->
		<div class="s-row s-my-7">
			<table class="s-table s-table-sm s-table-border-black">
				<thead class="s-center s-bg-silver">
					<tr>
						<th colspan="8" class="s-fs-3">Booking Information</th>
					</tr>
					<tr>
						<th class="s-w-2">Event ID</th>
						<th class="s-w-5">Event Type</th>
						<th class="s-w-18">Date</th>
						<th class="s-w-30">Event Time</th>
						<th class="">Location</th>
						<th class="s-w-20">Package</th>
						<th class="">Photographer</th>
						<th class="">Cinemetographer</th>
					</tr>
				</thead>
				<tbody class="s-center-middle">
					<?php foreach ($dtl as $key => $value) {
						$event_id = $value['event_id'];
						$event = $db->GetEventById($event_id);

						$package_dtl = $value['package_dtl'];

						$packageArr = PackageArr($package_dtl);

						$photo = 0;
						$chine = 0;

						foreach ($packageArr as $v) {
							$title = $v['title'];
							
							if (preg_match('/^(Photographer|Cinematographer)\s*\[(\d+)\]$/', $title, $matches)) {
								$role = strtolower($matches[1]);
								$count = (int) $matches[2];

								if ($role === 'photographer') {
									$photo = $count;
								}
								
								if ($role === 'cinematographer') {
									$chine = $count;
								}
							}
						}

						if ((float) ($value['outdoor_amt'] ?? 0) > 0) {
							$out = $db->GetEventOutdoor($event_id);

							// Outdoor
							echo "<tr>
							<td rowspan = '2'>$event_id</td>
							<td>Outdoor</td>
							<td rowspan = '2'>" . sDate($value['event_date_time']) . "</td>
							<td>" . $out['hours'] . "</td>
							<td>" . $out['venue'] . "</td>
							<td>-</td>
							<td>" . $out['photog'] . "</td>
							<td>" . $out['cinemetog'] . "</td>
						</tr>
						
						<tr>
							<td>" . $value['event_name'] . "</td>
							<td>" . $value['duration'] . "</td>
							<td>" . $event['venue'] . "</td>
							<td>" . $value['package_name'] . "</td>
							<td>" . $photo . "</td>
							<td>" . $chine . "</td>
						</tr>
						";
						} else {
							echo "<tr>
								<td>" . $event_id . "</td>
								<td>" . $value['event_name'] . "</td>
								<td>" . sDate($value['event_date_time']) . "</td>
								<td>" . $value['duration'] . "</td>
								<td>" . $event['venue'] . "</td>
								<td>" . $value['package_name'] . "</td>
								<td>" . $photo . "</td>
								<td>" . $chine . "</td>
							</tr>";
						}
					}
					?>
				</tbody>
			</table>
		</div>

		<!-- Billing Information -->
		<div class="s-row">
			<table align="center" class="w-75 s-table s-table-sm s-table-border-black">
				<thead class="s-center s-bg-silver">
					<tr>
						<th colspan="2" class="s-fs-3">Billing Information</th>
					</tr>
				</thead>
				<tbody class="s-center-middle">
					<tr>
						<td>Total Bill ( All Events )</td>
						<td class="s-w-25 s-bold"><?= sTakaFormat($bill) ?></td>
					</tr>
					<?php if ($discount > 0) {
						echo '<tr>
						<td>Special Discount</td>
						<td class="s-bold">' . sTakaFormat($discount) . '</td>
					</tr>
					<tr>
						<td>After Discount</td>
						<td class="s-bold">' . sTakaFormat($ttl_bill) . '</td>
					</tr>';
					} ?>
					<tr>
						<td>Advance Paid</td>
						<td class="s-bold"><?= sTakaFormat($pay) ?></td>
					</tr>
					<tr>
						<td>Balance Due</td>
						<td class="s-bold s-bg-red-300"><?= sTakaFormat($due) ?></td>
					</tr>
				</tbody>
			</table>
		</div>

		<!-- Note -->
		<div class="s-row">
			<span class="s-ml-2 s-bold"># Note:</span>
			<ul class="s-text-red s-fs-2">
				<li>If need any changes have to inform 2 weeks before the event.</li>
				<li>For more than 5 hours, the price will be increasing 2,000/- (BDT)for each person per hour. (6,000
					BDT for the Chief Photographer)</li>
				<li>Photos & videos will be saved up to 3 months after the event.</li>
				<li>You will get 50% refund if you cancel 30 days before the event.</li>
			</ul>
		</div>

		<div class="s-row s-fs-2">
			<span>If you have any adjustments or further questions, please don’t hesitate to contact us.</span><br>
			<span>We are honored to be part of all your special occasions and look forward to capturing lasting memories
				for you.</span>
		</div>

		<div class="s-mt-6">
			<span>Best regards,</span><br>
			<img class="ms-4" src="<?= BASE_URL ?>print/raihan_signature.jpg" height="100" />
		</div>

		<div class="s-row">
			<div class="s-center s-bold">
				Thank You<br>Snap Moment<br>
				<span style="font-size: 12px;">www.snapmomentbd.com</span>
			</div>
		</div>

	</div>
</body>

</html>