<?php
include("../db/model.php");
include("../config/config.php");
$db = new Model();
$data = $db->GetEventById(600);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <link rel="stylesheet" href="<?= BASE_URL ?>style/download.css">
    <title>Booking Information</title>
</head>
<body>
    <div class="w-100 s-bg-black-800 s-py-4 s-center s-radius-tl-3 s-radius-tr-3">
        <img src="<?= BASE_URL ?>img/logo.png" alt="Snap Moment" width="250">
    </div>
    <div class="s-border-black-800 s-py-6 s-px-4">
        <div>Dear <strong>Zakia Ejaz</strong>,</div>
        
        <div class="s-mt-3">Thank you for choosing <strong>Snap Moment</strong> to capture your special memories. We are delighted to confirm that we have received your booking details as follows:</div>

        <div class="s-radius-2 s-mt-3 s-border-silver s-auto">
            <div class="s-bg-silver s-text-black s-center s-fs-4 s-py-3 s-bold">BOOKING INFORMATION</div>
            
            
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Booking ID</div>
                <div class="w-100 sm:-s-w-40"><?= $data["id"]?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Booking Date</div>
                <div class="w-100 sm:-s-w-40"><?= sDate($data["booking_date_time"], true, true)?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Event Date</div>
                <div class="w-100 sm:-s-w-40"><?= sDate($data["event_date_time"], true, true) ?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Client's Name</div>
                <div class="w-100 sm:-s-w-40"><?= $data["client_name"]?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Contact No</div>
                <div class="w-100 sm:-s-w-40"><?= $data["phone"]?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Email</div>
                <div class="w-100 sm:-s-w-40"><?= $data["email"]?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Event's Type</div>
                <div class="w-100 sm:-s-w-40"><?= $data["event_name"]?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Groom's Name</div>
                <div class="w-100 sm:-s-w-40"><?= $data["groom"]?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Bride's Name</div>
                <div class="w-100 sm:-s-w-40"><?= $data["bride"]?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Birthday Person's Name</div>
                <div class="w-100 sm:-s-w-40"><?= $data["birthday_person"]?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Organization's Name</div>
                <div class="w-100 sm:-s-w-40"><?= $data["org_name"]?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Packages</div>
                <div class="w-100 sm:-s-w-40"><?= $data["package_name"]?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Add Ons</div>
                <div class="w-100 sm:-s-w-40"><?= 'addons'?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Amount</div>
                <div class="w-100 sm:-s-w-40"><?= $data["total_amt"]?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Venue Location</div>
                <div class="w-100 sm:-s-w-40"><?= $data["venue"]?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Song Preference</div>
                <div class="w-100 sm:-s-w-40"><?= $data["song"]?></div>
            </div>
            <div class="s-row s-py-2 s-px-3 s-bg-striped-silver-200">
                <div class="s-flex w-100 sm:s-w-40 s-bold s-middle">Your Preference</div>
                <div class="w-100 sm:-s-w-40"><?= $data["preference"]?></div>
            </div>

        </div>
    </div>
</body>
</html>