<?php
include('db/model.php');
include('config/config.php');
$db = new Model();

$addonsList = $db->AddOnsList(true);
$eventId = (int) $_POST['eventId'];

if(isset($_POST['type'])){
    header('Content-Type: application/json');
    
    if ($_POST['type']=='add') {
        $result = $db->AddEventAddOns($_POST['addOnsId'], $_POST['eventId']);
        echo json_encode(['result' => $result]);
    }

    exit;
}

?>

<div class="modal fade" id="modalModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
    aria-labelledby="modalModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-md">
        <div class="modal-content">
            <div class="modal-header text-center">
                <h1 class="modal-title w-100" id="modalModalLabel">ADD EVENT ADD-ONS</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <div id="custom-form-dark">
                <div class="modal-body my-3">
                    <label for="" class="form-label">Add Ons</label>
                    <select id="addonsList" name="addonsList" class="form-control">
                        <?php
                        foreach ($addonsList as $addons) {
                            echo '<option value="' . $addons['id'] . '">' . $addons['name'] . ' (' . sCurrencySymbol(false) . $addons['amt'] . ')' . '</option>';
                        }
                        ?>
                    </select>
                </div>
            </div>

            <div class="modal-footer bg-dark">
                <button type="button" class="btn btn-secondary" id="addAddOns">Add</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        loadSelect2(['#addonsList'], '.modal-body');

        $('#addonsList').on('select2:open', function (e) {
            $('.select2-dropdown').addClass('custom-form-dark');
        });

        $('#addAddOns').on('click', function (e) {
            e.preventDefault();

            var eventId = <?php echo json_encode($eventId); ?>;
            var addOnsId = $.trim($('#addonsList').val());

            $.ajax({
                type: "post",
                url: "modal_add_event_addons.php",
                data: {
                    type: 'add',
                    eventId: eventId,
                    addOnsId: addOnsId
                },
                dataType: "json",
                success: function (response) {
                    location.reload();
                }
            });
        });
    });


</script>