<?php
$_page_title = "Collection";
$_main_root = '../';

require_once $_main_root . 'db/model.php';

$db = new Model();
$billMst = null;
$billDtl = null;
$empList = $db->EmployeeList(true);

if (isset($_POST['type'])) {
    header('Content-Type: application/json');

    if ($_POST['type'] == "find") {
        $eventId = (int) ($_POST['eventId'] ?? 0);
        $billNum = (int) ($_POST['billNum'] ?? 0);

        $billMst = null;

        if ($eventId > 0) {
            $billMst = $db->GetBillMst(false,$eventId, false);
        } elseif ($billNum > 0) {
            $billMst = $db->GetBillMst(false,$billNum);
        }

        if ($billMst) {
            $billNumber = $billMst['bill_num'];
            $billDtl = $db->GetBillDtlByBillNumber($billNumber, true);
            $billPayDtl = $db->GetBillPayDtlByBillNum($billNumber);
            echo json_encode(['billMst' => $billMst, 'billDtl' => $billDtl, 'billPayDtl' => $billPayDtl]);
        } else {
            echo json_encode(['bill' => false]);
        }

        exit;
    } elseif ($_POST['type'] == "pay") {
        $result = $db->BillPayment($_POST);
        echo json_encode(['flag' => $result]);
        exit;
    } elseif ($_POST['type'] == "cd") {
        $paymentId = $_POST["id"];
        $result = $db->DeleteEventPayment($paymentId);
        echo json_encode(['flag' => $result]);
        exit;
    }
}

include($_main_root . 'content/shared/header.php');

if (!Permission(2)) {
    return;
}
?>

<style>
    #dataTableDueList,
    #dataTablePay {
        --bs-table-bg: var(--s-background-color) !important;
    }
</style>


<!-- modal -->
<div id="modalDiv"></div>

<div class="container container-fluid">
    <input type="hidden" name="hBillNum" id="hBillNum" value="">
    <input type="hidden" name="hBillPayable" id="hBillPayable" value="">

    <div class="my-4 d-flex justify-content-between align-items-center">
        <h2 style="color:var(--s-text-color);">BILL COLLECTION</h2>
        <div>
            <a href="cust_bill.php" class="btn btn-sm btn-outline-info ms-3 fw-bold"><i class="bi bi-cpu me-2"></i> GENERATE BILL</a>
        </div>
    </div>

    <div class="row my-4">
        <div class="card bg-dark" style="border-color: var(--s-text-color);">
            <div class="card-body text-white">

                <div class="d-flex justify-content-between align-items-center">
                    <span style="color:var(--s-text-color);" class="fs-3">Bill Details</span>
                    <div>
                        <div class="input-group input-group-sm mb-0">
                            <div class="input-group-text btn-light fw-bold" id="custom-form-light">
                                <div class="form-check mb-0">
                                    <input type="radio" name="searchBill" id="eventIdSearch"
                                        class="form-check-input me-1" checked>
                                    <label for="eventIdSearch" class="form-check-label me-3">Event ID</label>
                                </div>
                                <div class="form-check mb-0">
                                    <input type="radio" name="searchBill" id="billNumSearch"
                                        class="form-check-input me-1">
                                    <label for="billNumSearch" class="form-check-label ">Bill Number</label>
                                </div>
                            </div>
                            <input type="text" class="form-control bg-dark text-light text-center"
                                id="searchEventTextBox">
                            <button class="btn btn-sm btn-light" id="searchEventBtn"><i
                                    class="bi bi-search"></i></button>
                        </div>
                    </div>
                </div>

                <div class="row my-2 justify-content-center">
                    <div class="col-12 col-md-6">
                        <table class="table table-sm table-dark border border-dark fs-5 w-100">
                            <thead>
                                <tr>
                                    <th style="width: 110px;"></th>
                                    <th style="width: 5px;"></th>
                                    <th></th>
                                    <th style="width: 110px;"></th>
                                    <th style="width: 5px;"></th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Bill Number</td>
                                    <td>:</td>
                                    <td class="fw-bold" id="billNumber"><?php echo InvoicePrefix::BILL_NUMBER; ?></td>
                                    <td>Bill Amount</td>
                                    <td>:</td>
                                    <td class="fw-bold" id="billAmount">0</td>
                                </tr>
                                <tr>
                                    <td>Discount</td>
                                    <td>:</td>
                                    <td class="fw-bold" id="billDiscount">0</td>
                                    <td>Due</td>
                                    <td>:</td>
                                    <td class="fw-bold text-danger" id="billDue">0</td>
                                </tr>
                                <tr>
                                    <td>Payment</td>
                                    <td>:</td>
                                    <td class="fw-bold text-success" id="billPayment">0</td>
                                    <td>Payable</td>
                                    <td>:</td>
                                    <td class="fw-bold text-success" id="billPayable">0</td>
                                </tr>
                                <tr>
                                    <td>Biller Name</td>
                                    <td>:</td>
                                    <td class="fw-bold" colspan="4">
                                        <input type="text" name="billerName" id="billerName" value="..."
                                            onfocus="this.select()"
                                            style="border-bottom:1px solid var(--s-text-color-2) !important;"
                                            class="form-control bg-dark border border-dark text-light fw-bold p-0 fs-5">
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

                    <div class="col-12 col-md-6">
                        <div class="row mb-4">
                            <div class="table-responsive" style="max-height: 150px;">
                                <table id="dataTableDueList"
                                    class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">
                                    <thead style="color:var(--s-text-color); position: sticky; top: 0; z-index: 1;"
                                        class="mt-3">
                                        <th>E.ID</th>
                                        <th class="w-100">Event</th>
                                        <th>Amount</th>
                                    </thead>
                                    <tbody class="text-center">
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-12 col-md-6">
                        <div class="row">
                            <label for="">Payment Details</label>
                            <div class="table-responsive" style="max-height: 150px;">
                                <table id="dataTablePay" class="table table-sm table-dark table-hover table-bordered"
                                    style="width: 100%;">
                                    <thead style="color:var(--s-text-color); position: sticky; top: 0; z-index: 1;"
                                        class="mt-3">
                                        <th style="width: 5px">E.ID</th>
                                        <th style="width: 90px;">Pay Date</th>
                                        <th style="width: 120px;">Payment Method</th>
                                        <th>Comment</th>
                                        <th style="width: 5px" <?= (Permission(2)) ? '' : 'rowspan="2"' ?>>Amount</th>
                                        <th style="width: 5px;">Action</th>
                                    </thead>
                                    <tbody class="text-center">
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                    <div class="col-12 col-md-6">
                        <label for="">Payment Method / Paid By :</label>
                        <hr class="mt-0">

                        <div class="row" id="custom-form-dark">
                            <div class="col-12 col-sm-6">
                                <div class="form-check">
                                    <input type="radio" name="payMethod" id="payCash" class="form-check-input me-2"
                                        checked>
                                    <label for="payCash" class="form-check-label">Cash</label>
                                </div>
                                <div class="form-check">
                                    <input type="radio" name="payMethod" id="payBank" class="form-check-input me-2">
                                    <label for="payBank" class="form-check-label">Bank Transfer</label>
                                </div>
                            </div>

                            <div class="col-12 col-sm-6">
                                <div class="form-check">
                                    <input type="radio" name="payMethod" id="payMobileBank"
                                        class="form-check-input me-2">
                                    <label for="payMobileBank" class="form-check-label">Mobile Banking</label>
                                </div>
                                <div class="form-check">
                                    <input type="radio" name="payMethod" id="payCheque" class="form-check-input me-2">
                                    <label for="payCheque" class="form-check-label">Cheque</label>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-1">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text fw-bold text-primary">By</span>
                                <div class="flex-grow-1">
                                    <select name="empList" id="empList" class="fw-bold text-primary">
                                        <option value="">Select Received By</option>
                                        <?php foreach ($empList as $row): ?>
                                            <option value="<?php echo $row['id']; ?>" data-emp-name="<?= $row['full_name'] ?>">
                                                <?php echo $row['full_name'] . ' (' . $row['designation'] . ')'; ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-1">
                            <div class="input-group input-group-sm">
                                <span class="input-group-text fw-bold text-success">Payment Date</span>
                                <input type="text" class="form-control text-center fw-bold" id="payment_date">
                                <span class="input-group-text fw-bold text-success">(<?= sCurrencySymbol(false, false) ?>)</span>
                                <input type="text" name="payAmount" id="payAmount"
                                    class="form-control bg-dark text-light text-center">
                                <button id="paymentBtn" class="btn btn-light fw-bold text-success">Payment</button>
                            </div>
                        </div>


                        <div class="row mt-1">
                            <div class="print-invoice-button"></div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>

<?php $s_scripts = ['cust_bill_collection']; ?>
<?php include($_main_root . 'content/shared/footer.php'); ?>