<?php
$_page_title = "User List";
$_main_root = '../';
include($_main_root . 'content/common/header.php');

if (!Permission()) {
    return;
}
require_once $_main_root.'db/model.php';
$obj = new Model();
$userList = $obj->UserList()
?>

<!-- modal -->
<div id="userModalDiv"></div>

<div class="container container-fluid">
    <div class="my-4 d-flex justify-content-between align-items-center">
        <h2 style="color:var(--s-text-color);">USER LIST</h2>
        <button class="btn btn-sm btn-outline-success ms-3" onclick="UserDetail(0)">
            <i class="bi bi-plus-circle me-2"></i> NEW USER
        </button>
    </div>
    
    <div class="row my-4">

            <div class="table-responsive-lg">
                <table id="dataTable" class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">

                    <thead style="color:var(--s-text-color);" class="mt-3">
                        <!-- <th>#</th> -->
                        <th class="w-50">Full Name</th>
                        <th>User Name</th>
                        <th>Designation</th>
                        <th>Status</th>
                        <th  class="">Action</th>
                    </thead>
                    <tbody>
                    <?php
                        if ($userList) {
                            foreach ($userList as $row) { ?>
                                <tr>
                                    <td><?php echo $row['full_name'] ?></td>
                                    <td><?php echo $row['username'] ?></td>
                                    <td class="text-center fw-bold text-success"><?php echo $user_roles[$row['desig_code']] ?></td>
                                    <td class="text-center fw-bold <?php echo ($row['status'])==1?'text-success':'text-danger'; ?>"><?php echo $user_status[$row['status']] ?></td>
                                    
                                    <td>
                                        <div class="text-center">
                                            <div class="btn-group">
                                                <button type="button" name="payment" class="btn btn-sm action-btn" onclick="UserDetail(<?php echo $row['id']; ?>)">
                                                    <i class="bi bi-pencil-square"></i>
                                                </button>
                                            </div>
                                        </div>
                                    </td>
                                </tr>

                        <?php }
                        } ?>
                    </tbody>
                </table>

            </div>
    </div>
</div>

<?php $s_scripts = ['user']; ?>

<?php include($_main_root . 'content/common/footer.php'); ?>