<?php
$_main_root = '../';
include($_main_root . "db/model.php");
include($_main_root . "config/config.php");
$db = new Model();

$mst = null;
$dtl = null;
$dtlGrp = [];
$others = null;

if (isset($_GET['quote_id'])) {
	$mstId = (int) $_GET['quote_id'];
	$mst = $db->GetQuotationMst(false, $mstId);
	$dtl = $db->GetQuotationDetails($mstId, false, true);
	$result = $db->conn->query("SELECT event_date AS d, COUNT(event_date) AS t FROM quote_details WHERE mst_id = $mstId GROUP BY event_date HAVING COUNT(event_date) > 1");
	if ($result && $result->num_rows > 0) {
		while ($row = $result->fetch_assoc()) {
			$dtlGrp[] = $row;
		}
	}

	$others = $db->GetQuotationOthers($mstId);
}
?>

<!DOCTYPE html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<link rel="stylesheet" href="<?php echo $_main_root; ?>vendor/bootstrap-5.3.0/css/bootstrap.min.css">

	<title><?= strtoupper($mst['client_name']) . "_Quotation"; ?></title>

	<style>
		body {
			font-family: 'Times New Roman', Times, serif;
			margin: 0;
			padding: 0;
			max-width: 900px;
			margin: auto;
		}

		.custom-table-sm {
			font-size: 12px;
		}

		.custom-table-sm thead tr th,
		.custom-table-sm tbody tr td {
			padding: 1px 2px;
		}

		@media print {
			body * {
				visibility: hidden;
				margin: 0;
				padding: 0;
			}

			@page {
				size: Legal portrait;
				margin: 10mm;
			}

			.print-area,
			.print-area * {
				visibility: visible;
			}
		}
	</style>
</head>

<body>

	<div class="print-area m-3">

		<div class="row">
			<div class="col-12 text-center">
				<img src="logo_black.png" height="40" />
			</div>
		</div>

		<div class="row mt-3">
			<span class="fw-bold">Md Raihan Sayeem</span><br>
			<span class="" style="font-size: 12px;">Owner and Chief Photographer</span><br>
			<span class="ms-3 lh-sm" style="font-size: 12px;">Contact: +8801673-157878<br>Location: House #478,
				Road-7, Block- H, Bashundhara R/A, Dhaka.<br>Email: snapmomentbd@gmail.com</span><br>
		</div>

		<!-- To -->
		<div class="row mt-1">
			<span>To,</span><br>
			<span class="fw-bold"><?= $mst['client_name'] ?></span>
		</div>

		<!-- Purpose -->
		<div class="row mt-1 text-center fw-bold">
			<span>Purpose: <?= $mst["purpose"] ?></span>
		</div>

		<!-- Details -->
		<div class="row mt-3">
			<span class="fw-bold">◾ Details :</span>
			<table class="table custom-table-sm table-bordered text-center border-dark">
				<thead style="background-color: silver;">
					<tr>
						<th>Date</th>
						<th>Location</th>
						<th>Package</th>
						<th>Event Time</th>
						<th>Reporting Time</th>
						<th>Photographer</th>
						<th>Cinemetographer</th>
					</tr>
				</thead>
				<tbody>
					<?php 
					$preDate = ""; 
					foreach ($dtl as $row) { 
						if ($preDate != $row["event_date"]) {
							$rowSpan = 1;
							foreach ($dtlGrp as $dg) {
								if ($row["event_date"] === $dg["d"]) {
									$rowSpan = (int) $dg["t"];
									break;
								}
							}
							?>
							<tr>
								<td class="text-center align-middle" rowspan="<?= $rowSpan ?>"><?= sDate($row["event_date"]) ?></td>
								<td><?= $row["location"] ?></td>
								<td><?= $row["package_name"] . (((int) $row["add_ons_id"] > 0) ? " + Add-Ons" : "") ?></td>
								<td><?= $row["event_time"] ?></td>
								<td><?= $row["report_time"] ?></td>
								<td><?= $row["photog"] ?></td>
								<td><?= $row["cinemetog"] ?></td>
							</tr>
						<?php 
						} else { ?>
							<tr>
								<td><?= $row["location"] ?></td>
								<td><?= $row["package_name"] . (((int) $row["add_ons_id"] > 0) ? " + Add-Ons" : "") ?></td>
								<td><?= $row["event_time"] ?></td>
								<td><?= $row["report_time"] ?></td>
								<td><?= $row["photog"] ?></td>
								<td><?= $row["cinemetog"] ?></td>
							</tr>
						<?php 
						} 
						$preDate = $row["event_date"];
					} 
					?>

				</tbody>
			</table>
		</div>

		<!-- Others -->
		<div class="row">
			<span class="fw-bold">◾ Others :</span>
			<table class="table custom-table-sm table-bordered text-center border-dark">
				<thead style="background-color: silver;">
					<tr>
						<th>Edited Photos</th>
						<th>Printed Photos</th>
						<th>Photo Quantity</th>
						<th>Promo</th>
						<th>Video</th>
						<th>Album</th>
						<th>Photo Frame (10L)</th>
						<th>Drone</th>
					</tr>
				</thead>
				<tbody>
					<?php if (!empty($others)) { ?>
						<tr>
						<td class="align-middle"><?= $others["edited_photo"] ?></td>
						<td class="align-middle"><?= $others["printed_photo"] ?></td>
						<td class="align-middle"><?= $others["photo_quality"] ?></td>
						<td class="align-middle"><?= $others["promo"] . "<br>(2-3 Minutes)" ?></td>
						<td class="align-middle"><?= $others["video"] . "<br>(15-25 Minutes)" ?></td>
						<td class="align-middle"><?= $others["album"] ?></td>
						<td class="align-middle"><?= $others["pf_10l"] ?></td>
						<td class="align-middle"><?= $others["drone"] ?></td>
					</tr>
					<?php } else {
						echo '<tr><td colspan="8">Others is not defined in this Quotation.</td></tr>';
						}?>
				</tbody>
			</table>
		</div>

		<!-- Cost Breakdown -->
		<div class="row">
			<span class="fw-bold">◾ Cost Breakdown :</span>
			<table class="table custom-table-sm table-bordered text-center border-dark">
				<thead style="background-color: silver;">
					<tr>
						<th>Purpose</th>
						<th>Event Type</th>
						<th>Package Duration</th>
						<th>Price (BDT)</th>
					</tr>
				</thead>
				<tbody>
					<?php foreach ($dtl as $row) {
						$purposeArr = PackageArr($row['purpose']);
						$purposeDtl = "Package: <b>" . htmlspecialchars($row["package_name"]) . (((int) $row["add_ons_id"] > 0) ? " + Add-Ons" : "") . "</b>";
						$purposeDtl = ((int) $row["package_id"] == 0) ? "" : $purposeDtl;
						if (!empty($purposeArr)) {
							foreach ($purposeArr as $value) {
								$purposeDtl .= (empty($purposeDtl)?"":"</br>")."<b> • " . htmlspecialchars($value["title"]) . "</b>";
								$purposeDtl .= "<br>" . htmlspecialchars($value["details"]);
							}
						}
						$total = ((int) $row["package_id"] == 0) ? $row["out_amt"] : $row["total"];
						?>
						<tr>
							<td class=""><?= $purposeDtl ?></td>
							<td class="align-middle"><?= $row["event_type"] ?></td>
							<td class="align-middle"><?= nl2br($row["duration"]) ?></td>
							<td class="align-middle"><?= sTakaFormat($total) ?></td>
						</tr>
					<?php } ?>
					<tr class="fw-bold">
						<td colspan="3" class="text-end">Total : </td>
						<td><?= sTakaFormat($mst["amount"], false, true, false) ?></td>
					</tr>
					<?php $discount = (int) ($mst["discount"] ?? 0); if ($discount > 0) {?>
						<tr class="fw-bold">
							<td colspan="3" class="text-end">After Speacial Discount : </td>
							<td><?= sTakaFormat($mst["total_amt"], false, true, false) ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>

		<!-- In Word -->
		<div class="row text-center">
			<span class="fw-bold" colspan="4">In Word: <?= sNumberToWords($mst["total_amt"]) ?></span>
		</div>

		<!-- Note -->
		<div class="row mt-3">
			<span class="fw-bold">◾ Note:</span>
			<ul class="text-danger ms-5" style="font-size:10px;">
				<li>If need any changes have to inform 2 weeks before the event.</li>
				<li>For more than 5 hours, the price will be increasing 2,000/- (BDT)for each person per hour. (6,000
					BDT for the Chief Photographer)</li>
				<li>Photos & videos will be saved up to 3 months after the event.</li>
				<li>You will get 50% refund if you cancel 30 days before the event.</li>
			</ul>
		</div>

		<!-- Delivery Timing -->
		<div class="row mt-1">
			<div class="">
				<span class="fw-bold">◾ Delivery Timing:</span>
				<span style="font-size:12px;">Maximum 45 days after the event.</span>
			</div>
		</div>

		<!-- Confirmation -->
		<div class="row mt-1">
			<div class="">
				<span class="fw-bold">◾ Confirmation:</span>
				<span style="font-size:12px;">Please complete the booking form and pay
					minimum<?= sTakaFormat(((int) $mst["total_amt"]) / 2, false, true) ?>/- of the total amount in advance.
					The remaining balance will be due at the end of the final event day.</span>
			</div>
		</div>

		<div class="row">
			<div class="col-12 text-center fw-bold lh-sm">
				Thank You<br>Snap Moment<br>
				<span style="font-size: 12px;">www.snapmomentbd.com</span>
			</div>
		</div>

	</div>

	<div class="text-center" style="padding:20px;">
		<input type="button" value="Print" class="btn btn-success btn_print" onclick="print_summary()">
	</div>

	<script>
		window.onload = function () {
			window.print();
		};

		function print_summary() {
			window.print();
		}
	</script>
</body>

</html>