<?php
require_once '../db/model.php';
$db = new Model();
if (isset($_POST['type'])) {

    if ($_POST['type'] == "assignEmpList") {
        $list = $db->GetAssignedEmpEvent();
        header('Content-Type: application/json');
        echo json_encode($list);
        exit();
    }

    if ($_POST['type']=="assigEmp") {
        $event_id=$_POST['event_id'];
        $empList = $db->GetAssignedEmpByEventId($event_id);
        header('Content-Type: application/json');
        echo json_encode($empList);
        exit();
    }
}
?>
<style>
    #dataTable tbody td:nth-child(1) {
        text-align: center;
    }

    #dataTable tbody tr {
        cursor: pointer;
    }

    #dataTable tbody tr td table tbody tr {
        cursor: default;
    }
</style>

<div class="table-responsive">
    <table id="dataTable" class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">
        <thead style="color:var(--s-text-color);" class="mt-3">
            <th style="width: 100px">Event Date</th>
            <th style="width: 50px">Event Type</th>
            <th style="width: 130px">Package Type</th>
            <th>Location</th>
            <th style="width: 50px">Assign Emp</th>
        </thead>
        <tbody>
        </tbody>
    </table>

</div>

<script>
    $(document).ready(function() {
        table = $('#dataTable').DataTable({
            "order": [],
            ajax: {
                url: 'report_assign_emp_event.php',
                type: 'POST',
                data: {
                    type: 'assignEmpList'
                },
                dataSrc: function(json) {
                    return json;
                },
            },
            columns: [
                {
                    data: null,
                    render: function(data) {
                        return sDate(data['event_date_time']);
                    }
                },
                {
                    data: 'event_name'
                },
                {
                    data: 'package_name'
                },
                {
                    data: 'venue'
                },
                {
                    data: null,
                    render: function(data, type, row) {
                        return data['assi_emp_count'] + ' <i class="ms-2 toggle-arrow bi bi-chevron-down"></i>';
                    }
                }
            ]
        });

        $('#dataTable tbody').on('click', 'tr', function() {
            var tr = $(this);
            var row = table.row(tr);

            if (row.child.isShown()) {
                row.child.hide();
                tr.removeClass('shown');
                tr.find('.toggle-arrow').removeClass('bi-chevron-up').addClass('bi-chevron-down');
            } else {
                var data = row.data();
                var childContent = `
                        <table class="table table-sm table-dark table-bordered" id="sub-table" style="color:var(--s-text-color-2);">
                            <thead class="table-secondary">
                                <tr>
                                    <th style="width:50px;">#</th>
                                    <th>Employee Name</th>
                                    <th>Designation</th>
                                    <th style="width: 200px;">Employee Phone</th>
                                    <th style="width: 100px;">Payable</th>
                                </tr>
                            </thead>
                            <tbody>`;
                $.ajax({
                    url: 'report_assign_emp_event.php',
                    type: 'POST',
                    data: {
                        type: 'assigEmp',
                        event_id: data['event_id']
                    },
                    success: function(response) {
                        response.forEach(function(emp, index) {
                            childContent += `
                                    <tr>
                                        <td class="text-center">${index+1}</td>
                                        <td class="text-start">${emp.full_name}</td>
                                        <td class="text-start">${emp.designation}</td>
                                        <td class="text-start">${emp.phone_number}</td>
                                        <td class="text-end">${emp.payable_amt}</td>
                                    </tr>
                                `;
                        });
                        childContent += `</tbody>
                        </table>`;

                        row.child(childContent).show();
                    }
                });

                tr.addClass('shown');
                tr.find('.toggle-arrow').removeClass('bi-chevron-down').addClass('bi-chevron-up');
            }
        });

    });
</script>