<?php
include('../db/model.php');
include('../config/config.php');
$obj = new Model();
// $tableHeight='';
$forUpdate = false;
$id = 0;

$desigList = $obj->EmpDesigList();

if (isset($_POST['id'])) {
    $id = (int) $_POST['id'];
    if (is_numeric($id) && $id > 0 && $id != '' && $id != null) {
        $forUpdate = $id > 0;
        $emp = $obj->GetEmpById($id);
    }
}

if (isset($_POST['type'])) {
    if ($_POST['type'] == 'add') {
        $result = $obj->AddEmp($_POST);
        header('Content-Type: application/json');

        if (strlen($result) == 1) {
            echo json_encode(['success' => true, 'message' => 'Employees successfully added']);
        } else {
            echo json_encode(['success' => false, 'message' => $result]);
        }
    } else if ($_POST['type'] == 'update') {
        $result = $obj->UpdateEmp($_POST);
        header('Content-Type: application/json');

        if (strlen($result) == 1) {
            echo json_encode(['success' => true, 'message' => 'Employees successfully updated']);
        } else {
            echo json_encode(['success' => false, 'message' => $result]);
        }
    }
    exit;
}

?>
<div class="modal fade" id="modalModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
    aria-labelledby="modalModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header text-center">
                <h1 class="modal-title fs-5 w-100" id="modalModalLabel">
                    <?php if ($forUpdate) {
                        echo 'Update Employee';
                    } else {
                        echo 'Add New Employee';
                    } ?></h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            
            <div id="custom-form-light">
                <div class="modal-body">

                    <input type="hidden" name="mId" id="mId" value="<?php if ($forUpdate) {
                        echo $emp['id'];
                    } ?>">

                    <div class="mb-3">
                        <label for="mFullName">Full Name</label>
                        <input type="text" name="mFullName" id="mFullName"
                            value="<?php if ($forUpdate) {
                                echo $emp['full_name'];
                            } ?>" class="form-control">
                    </div>

                    <div class="input-group">
                        <div class="col-12 col-sm-12 col-md-6 mb-3 pe-md-2">
                            <label for="mEmail">Email</label>
                            <input type="email" name="mEmail" id="mEmail"
                                value="<?php if ($forUpdate) {
                                    echo $emp['email'];
                                } ?>" class="form-control">
                        </div>

                        <div class="col-12 col-sm-12 col-md-6 mb-3 ms-auto me-0 ps-md-2">
                            <label for="mPhoneNumber">Phone Number</label>
                            <input type="text" name="mPhoneNumber" id="mPhoneNumber"
                                value="<?php if ($forUpdate) {
                                    echo $emp['phone_number'];
                                } ?>" class="form-control">
                        </div>
                    </div>

                    <div class="input-group">
                        <div class="col-12 col-sm-12 col-md-6 mb-3 pe-md-2">
                            <label for="mAddress">Address</label>
                            <input type="text" name="mAddress" id="mAddress"
                                value="<?php if ($forUpdate) {
                                    echo $emp['address'];
                                } ?>" class="form-control">
                        </div>

                        <div class="col-12 col-sm-12 col-md-6 mb-3 ms-auto me-0 ps-md-2">
                            <label for="mSalary">Salary Amount</label>
                            <input type="number" name="mSalary" id="mSalary"
                                value="<?php if ($forUpdate) {
                                    echo $emp['salary'];
                                } ?>" class="form-control">
                        </div>
                    </div>

                    <div class="input-group">
                        <?php $selected = '0';
                        if ($forUpdate) {
                            $selected = $emp['desig_code'];
                        } ?>
                        <div class="col-12 col-sm-12 col-md-6 mb-3 pe-md-2">
                            <label for="designation">Designation</label>
                            <select name="designation" id="designation" class="form-control form-select">
                                <?php foreach ($desigList as $desig) { ?>
                                    <option value="<?php echo $desig['id']; ?>" <?php echo ($selected == $desig['id']) ? 'selected' : ''; ?>>
                                        <?php echo $desig['name']; ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>

                        <div class="col-12 col-sm-12 col-md-6 mb-3 ms-auto me-0 ps-md-2">
                            <label for="mUserStatus">Status</label>
                            <div class="input-group">
                                <div class="form-check ps-5">
                                    <input class="form-check-input" type="radio" name="mUserStatus"
                                        id="mUserStatusActive" <?php if ($forUpdate) {
                                            if ($emp['status'] == 1) {
                                                echo 'checked';
                                            }
                                        } ?>>
                                    <label class="form-check-label" for="mUserStatusActive">
                                        Active
                                    </label>
                                </div>
                                <div class="form-check ps-5">
                                    <input class="form-check-input" type="radio" name="mUserStatus"
                                        id="mUserStatusDeActive" <?php if ($forUpdate) {
                                            if ($emp['status'] == 0) {
                                                echo 'checked';
                                            }
                                        } ?>>
                                    <label class="form-check-label" for="mUserStatusDeActive">
                                        De-Active
                                    </label>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <div class="validationErrorMsg"></div>

                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                    <?php if ($forUpdate) { ?>
                        <button type="submit" name="payment" class="btn btn-primary" onclick="UpdateEmp()">Update</button>
                    <?php } else { ?>
                        <button type="submit" name="payment" class="btn btn-primary" onclick="AddEmp()">Add</button>
                    <?php } ?>

                </div>
            </div>
            <!-- </form> -->
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        loadSelect2(['#designation'], '.modal-body');

        $('#designation').on('select2:open', function (e) {
            $('.select2-dropdown').addClass('custom-form');
        });
    });
</script>