<?php
$_main_root = '../';
require_once $_main_root . 'db/model.php';

$db = new Model();
if (isset($_POST['type'])) {
    header('Content-Type: application/json');
    
    if ($_POST['type'] == "list") {
        $list = $db->GetQuotation();
        echo json_encode($list);
    }elseif ($_POST['type'] == "d") {
        $flag = $db->QuotationDelete(true,$_POST['id']);
        echo json_encode($flag);
    }
    exit;
}

?>

<div class="table-responsive">
    <table id="tableQuote" class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">
        <thead style="color:var(--s-text-color);" class="mt-3">
            <th style="width: 50px;">#</th>
            <th style="">Client Name</th>
            <th style="">Purpose</th>
            <th style="">Amount</th>
            <th style="width: 5px;">Action</th>
        </thead>
        <tbody></tbody>
    </table>
</div>

<script>
    $(document).ready(function () {
        table = $('#tableQuote').DataTable({
            order: [],
            ajax: {
                url: 'cust_quotation_list_all.php',
                type: 'POST',
                data: {
                    type: 'list'
                },
                dataSrc: function (json) {
                    return json;
                },
            },
            columns: [
            {data: 'id'},
            {data: 'client_name'},
            {data: 'purpose'},
            {data: 'amount'},
            {
                data: null,
                render: function (data, type, row) {
                    var btn = `<div class="btn-group">
                    <a href="cust_quotation.php?quote_id=${row.id}" class="btn btn-sm action-btn"><i class="bi bi-pencil-square"></i></a>
                    <a href="../print/cust_quotation.php?quote_id=${row.id}" class="btn btn-sm action-btn"><i class="bi bi-printer-fill"></i></a>
                    ${Permission()?`<button class="btn btn-sm action-btn quote-delete" data-quote_id="${row.id}"><i class="bi bi-trash-fill"></i></button>`:``}
                    </div>`;
                    return btn;
                }
            }
            ],
            columnDefs: [
                { targets: 0, className: 'dt-center' },
                { targets: 3, className: 'dt-center' },
                { targets: 4, className: 'dt-center' }
            ]
        });

        $(document).on('click', '.quote-delete', function () {
            var quote_id = $(this).data('quote_id');
            
            sAlertConfirm(()=>{
                $.ajax({
                type: "post",
                url: "cust_quotation_list_all.php",
                data: {
                    type: "d",
                    id: quote_id
                },
                dataType: "json",
                success: function (response) {
                    sAlert("Quotation Deleted");
                    $('#tableQuote').DataTable().ajax.reload();
                }
            });
            })
        });

    });
</script>