function UserDetail(id) {
  $.ajax({
    type: "post",
    url: "modal_user.php",
    data: {
      type: "form",
      id: id,
    },
    success: function (sData) {
      $("#userModalDiv").html("");
      $("#userModalDiv").append(sData);
      $("#userModal").modal("show");
    },
  });
}

function AddUser() {
  var userName = $("#mUserName").val();
  var fullName = $("#mFullName").val();
  var pass = $("#mPassword").val();
  var userDesig = $("#designation").val();
  var userStatus = document.getElementById('mUserStatusActive').checked ? 1 : 0;

  if (userName === "" || userName === null) {
    $("#mUserName").css("border-color", "red");
    return;
  }

  if (fullName === "" || fullName === null) {
    $("#mFullName").css("border-color", "red");
    return;
  }

  if (pass === null || pass === "") {
    $("#mPassword").css("border-color", "red");
    return;
  }

  $.ajax({
    type: "post",
    url: "modal_user.php",
    data: {
      type: "add",
      userName: userName,
      fullName: fullName,
      pass: pass,
      status: userStatus,
      desig: userDesig
    },
    success: function (sData) {
      $("#userModal").modal("hide");
      table.ajax.reload();
    },
  });
}

function UpdateUser() {
  var id = $("#mId").val();
  var userName = $("#mUserName").val();
  var fullName = $("#mFullName").val();
  var pass = $("#mPassword").val();
  var userDesig = $("#designation").val();
  var userStatus = document.getElementById('mUserStatusActive').checked ? 1 : 0;

  if (userName === "" || userName === null) {
    $("#mUserName").css("border-color", "red");
    return;
  }

  if (fullName === "" || fullName === null) {
    $("#mFullName").css("border-color", "red");
    return;
  }

  if ((id === "" || id === null) && (pass === null || pass === "")) {
    $("#mPassword").css("border-color", "red");
    return;
  }

  swal({
    title: "Are you sure?",
    text: "Update this user!",
    icon: "warning",
    buttons: true,
    dangerMode: true,
  }).then((willDelete) => {
    if (willDelete) {
      $.ajax({
        type: "post",
        url: "modal_user.php",
        data: {
          type: "update",
          id: id,
          userName: userName,
          fullName: fullName,
          pass: pass,
          status: userStatus,
          desig: userDesig
        },
        success: function (sData) {
          $("#userModal").modal("hide");
          table.ajax.reload();
          swal("Successfully updated!", {
            icon: "success",
          });
        },
      });
    }
  });
}
