function assignEmployee() {
  var eventId = $("#eventId").val();
  var emp_id = $("#empList").val();

  var shiftPayable = parseInt($('#shiftPayable').val()) || 0;
  var shiftCount = parseFloat($('#totalShift').val()) || 1;
  var totalShiftPayable = parseInt($('#totalShiftPayable').val()) || 0;

  var hourPayable = parseInt($('#perHour').val()) || 0;
  var totalHour = parseFloat($('#totalHour').val()) || 0;
  var extraHourPayable = parseInt($('#extraHourPayable').val()) || 0;

  var editingFee = parseInt($('#editingFee').val()) || 0;
  var travelCost = parseInt($('#travelCost').val()) || 0;

  var totalPayable = parseInt($('#totalPayable').val()) || 0;

  if (emp_id == "" || emp_id == 0) {
    swal("Please select Employee", {
      icon: "warning",
    });
  } else {
    $.ajax({
      type: "post",
      url: "modal_assign_emp.php",
      data: {
        type: "assign",
        eventId: eventId,
        empId: emp_id,
        shiftPayable: shiftPayable,
        shiftCount: shiftCount,
        totalShiftPayable: totalShiftPayable,
        hourPayable: hourPayable,
        totalHour: totalHour,
        extraHourPayable: extraHourPayable,
        editingFee: editingFee,
        travelCost: travelCost,
        totalPayable: totalPayable,
      },
      success: function (response) {
        if (response.result) {
          swal({
            title: "" + response.message,
            text: "What would you like to do next?",
            icon: "success",
            buttons: {
              button1: {
                text: "Add another employee",
                value: "addAnother",
                className: "btn action-btn",
              },
              button2: {
                text: "Close",
                value: "close",
                className: "btn action-btn",
              },
            },
          }).then((value) => {
            if (value === "addAnother") {
              $("#modalModal").modal("hide");
              $("#modalDiv").html("");
              AssignModal(eventId);
            } else if (value === "close") {
              $("#modalModal").modal("hide");
              $("#modalDiv").html("");
            }
          });
        } else {
          swal("" + response.message, {
            icon: "error",
          });
        }
      }
    });
  }
};

function AssignModal(id) {
  $.ajax({
    type: "post",
    url: "modal_assign_emp.php",
    data: {
      type: "",
      id: id,
    },
    success: function (sData) {
      $("#modalDiv").html("");
      $("#modalDiv").append(sData);
      $("#modalModal").modal("show");
    },
  });
}

function DeleteAssign(id, eventId) {
  swal({
    title: "Are you sure?",
    text: "Once deleted, you will not be able to recover this entry!",
    icon: "warning",
    buttons: true,
    dangerMode: true,
  }).then((willDelete) => {
    if (willDelete) {
      $.ajax({
        type: "post",
        url: "modal_assign_emp.php",
        data: {
          type: "delete",
          id: id,
          eventId, eventId,
        },
        success: function (sData) {
          $("#modalModal").modal("hide");
          swal("Poof! Your entry has been deleted!", {
            icon: "success",
          });
        },
      });
    }
  });
}