<?php
session_start();
$_main_root = '../';
include($_main_root . "config/enum.php");
if (!isset($_login_page) || !$_login_page) {

	if (!User::Login()) {
		header("Location: " . $_main_root . "index.php");
		exit();
	}
}

$_page_title = "Employee Ledger";

include($_main_root . "config/config.php");
include($_main_root . "db/model.php");
$obj = new Model();

$ledger = null;
$emp = null;

if (isset($_GET['ei'])) {
	$emp_id = $_GET['ei'];
	$fromDate = $_GET['f'];
	$toDate = $_GET['t'];

	$data = [
		'emp_id' => $emp_id,
		'fromDate' => $fromDate,
		'toDate' => $toDate
	];

	if ($emp_id > 0) {
		$ledger = $obj->GetEmpLedgerByEmpId($data, true, true);
		$emp = $obj->GetEmpById($emp_id);
	}
}


?>

<!DOCTYPE html>
<html>

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<!-- Bootstrap CSS -->
	<link rel="stylesheet" href="<?php echo $_main_root; ?>vendor/bootstrap-5.3.0/css/bootstrap.min.css">

	<title><?php echo strtoupper($emp['full_name']); ?>_LEDGER</title>

	<style>
		body {
			font-family: 'Times New Roman', Times, serif;
		}

		.invoice-box {
			max-width: 900px;
			margin: auto;
			font-size: 16px;
			line-height: 24px;
			color: #000;
		}

		@media print {
			body * {
				visibility: hidden;
			}

			@page {
				size: A4 portrait;
				margin: 10mm;
			}

			.container_content,
			.container_content * {
				visibility: visible;
			}
		}
	</style>

</head>

<body>

	<div class="container_content">
		<div class="invoice-box">

			<!-- report header section -->
			<table class="w-100" style="background-color:#E6E6E6;">
				<tr>
					<td>
						<img src="snapmoment_logo.png"
							style="width: 100%; max-width: 300px; margin-top: 20px !important; margin-left: -22px !important; " />
					</td>
					<td style="text-align: right;">
						<h3 style="margin-top: 20px; margin-right: 15px;">EMPLOYEE LEDGER</h3><br /><br />
						<p style="margin-right: 15px; font-size:20px;">Print Date: <?php echo sDate(date("Y-m-d")) ?>
						</p>
					</td>
				</tr>
			</table>

			<!-- company address and client contact -->
			<table class="my-3 w-100">
				<!-- <tr>
					<td></td>
					<td style="text-align: right; margin-right: 10px;">
						Contact: +8801673-157878 <br />
						Location: House #478, Road-7, Block- H, <br />
						Bashundhara R/A, Dhaka
					</td>
				</tr> -->
				<tr>
					<td>
						To ,<br />
						<h5>
							<strong><?php echo strtoupper($emp['full_name']); ?></strong><br />
							<?php echo $emp['designation']; ?> <br />
						</h5>
						Contact: <?php echo $emp['phone_number']; ?> <br />
						Email: <?php echo $emp['email']; ?>
					</td>

				</tr>
			</table>

			<div class="d-flex justify-content-between">
				<div class="">
					<strong>Ledger Details :</strong>
				</div>
				<div class="">
					<strong>Showing Ledger : <?php echo sDate($fromDate); ?> to <?php echo sDate($toDate); ?></strong>
				</div>
			</div>
			<table class="table table-bordered border-dark mt-1">
				<thead class="table-dark">
					<tr class="text-center" style="font-size: 15px;">
						<th style="padding: 3px; ">#</th>
						<!-- <th style="width:120px;">Assign Date</th> -->
						<th style="padding: 3px; width:170px;">Event / Payment Date</th>
						<th style="padding: 3px; ">Event & Payment Details</th>
						<th style="padding: 3px; width: 100px;">Payable</th>
						<th style="padding: 3px; width: 100px;">Payment</th>
					</tr>
				</thead>
				<tbody id="ledgerTableBody">

					<?php $sl = 1;
					$payable = 0;
					$pay = 0;
					$countEvent = 0;
					$countPayment = 0;
					if ($ledger) {
						foreach ($ledger as $row) {
							$payableAmt = $row['payable_amt'];
							$payment = $row['payment'];
							$payable += $payableAmt;
							$pay += $payment;
							$countEvent += ($payableAmt > 0) ? 1 : 0;
							$countPayment += ($payment > 0) ? 1 : 0;
							?>
							<tr class="">
								<td style="padding: 0 5px 0 5px; text-align: center;"><?php echo $sl++ ?></td>
								<!-- <td style="padding: 0 5px 0 5px; text-align: center;"><?php echo sDate($row['create_at']); ?></td> -->
								<td style="padding: 0 5px 0 5px; text-align: center;"><?php echo sDate($row['date']); ?></td>
								<td style="padding: 0 5px 0 5px; text-align: left;"><?php echo $row['remarks']; ?></td>
								<td style="padding: 0 5px 0 5px; text-align: right;"><?php echo $row['payable_amt']; ?></td>
								<td style="padding: 0 5px 0 5px; text-align: right;"><?php echo $row['payment']; ?></td>
							</tr>
						<?php }
					} ?>
					<tr>
						<td style="padding: 0 5px 0 5px; text-align: right;" class="mt-5 text-end fw-bold" colspan="3">
							<div class="d-flex justify-content-between">
								<div>
									<?php
									echo $countEvent . (($countEvent > 1) ? " Events" : " Event");
									echo " & ";
									echo $countPayment . (($countPayment > 1) ? " Payments" : " Payment");
									?>
								</div>
								<div>Total = </div>
							</div>
						</td>
						<td style="padding: 0 5px 0 5px; text-align: right;" class="mt-5 text-end fw-bold">
							<?php echo $payable; ?>
						</td>
						<td style="padding: 0 5px 0 5px; text-align: right;" class="mt-5 text-end fw-bold">
							<?php echo $pay; ?>
						</td>
					</tr>
					<td class="mt-5 text-center fw-bold fs-5" colspan="6" style="background-color:#E6E6E6;">
						Balance:<?php echo sTakaFormat($emp['due_amt'], false, true); ?></td>
				</tbody>
			</table>

			<!-- signature and paid logo -->

			<table class="w-100">
				<tr>
					<td>
						<img class="ms-4" src="raihan_signature.jpg" style="height: 110px;" />
					</td>
				</tr>
			</table>
		</div>
	</div>

	<div class="text-center" style="padding:20px;">
		<input type="button" value="Download" class="btn btn-success btn_print" onclick="print_summary()">
	</div>

	<script src="<?php echo $_main_root; ?>vendor/DataTables/jQuery-3.6.0/jquery-3.6.0.min.js"></script>
	<script src="<?php echo $_main_root; ?>vendor/bootstrap-5.3.0/js/bootstrap.bundle.min.js"></script>

	<script>
		$(document).ready(function () {
			window.print();
		});

		function print_summary() {
			window.print();
		}
	</script>

</body>

</html>