<?php
include('../db/model.php');
include('../config/config.php');
$db = new Model();
$forUpdate = false;
$id = 0;

$package_list = $db->PackageList();

if (isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    if (is_numeric($id) && $id > 0 && $id != '' && $id != null) {
        $forUpdate = $id > 0;
        $discount = $db->GetDiscountById($id);
    }
}

if (isset($_POST['type'])) {
    if ($_POST['type'] == 'add') {
        $result = $db->AddDiscount($_POST);
        header('Content-Type: application/json');

        if (strlen($result) == 1) {
            echo json_encode(['success' => true, 'message' => 'Discount Successfully Added']);
        } else {
            echo json_encode(['success' => false, 'message' => $result]);
        }
    } else if ($_POST['type'] == 'update') {
        $result = $db->UpdateDiscount($_POST);
        header('Content-Type: application/json');

        if (strlen($result) == 1) {
            echo json_encode(['success' => true, 'message' => 'Discount Successfully Updated']);
        } else {
            echo json_encode(['success' => false, 'message' => $result]);
        }
    }
    exit;
}

?>
<div class="modal fade" id="modalModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="modalModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header text-center">
                <h1 class="modal-title fs-5 w-100" id="modalModalLabel"><?php if ($forUpdate) {
                                                                            echo 'Update Discount';
                                                                        } else {
                                                                            echo 'Add New Discount';
                                                                        } ?></h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div id="custom-form-light">
                <div class="modal-body">
                    <input type="hidden" name="id" id="id" value="<?php if ($forUpdate) {
                                                                        echo $discount['id'];
                                                                    } ?>">

                    <div class="mb-3">
                        <label for="packageName">Package Name</label>
                        <select id="packageName" name="packageName" class="form-control form-select">
                            <option value="">Select Package</option>
                            <?php
                            foreach ($package_list as $package) {
                                echo '<option value="' . $package['id'] . '" data-package-amount="' . $package['amt'] . '" ';
                                if ($forUpdate) {
                                    echo ($package['id'] == $discount['package_id']) ? "selected" : "";
                                }
                                echo '>';
                                echo $package['name'] . ' - ' . sCurrencySymbol() . $package['amt'];
                                echo '</option>';
                            }
                            ?>

                        </select>
                    </div>

                    <div class="input-group">
                        <div class="col-12 col-md-6 mb-3 pe-md-2">
                            <label for="discountAmount">Discount Amount</label>
                            <input type="number" name="discountAmount" id="discountAmount" value="<?php if ($forUpdate) {
                                                                                                        echo $discount['discount_amt'];
                                                                                                    } ?>" class="form-control" placeholder="0">
                        </div>
                        <div class="col-12 col-md-6">
                            <label for="afterDiscount">After Discount</label>
                            <input type="number" name="afterDiscount" id="afterDiscount" value="" class="form-control" placeholder="0" readonly>
                        </div>
                    </div>

                    <div class="input-group">
                        <div class="col-12 col-md-6 mb-3 pe-md-2">
                            <label for="validFrom">Valid From</label>
                            <input type="date" name="validFrom" id="validFrom" value="<?php if ($forUpdate) {
                                                                                            echo $discount['valid_from'];
                                                                                        } ?>" class="form-control">
                        </div>
                        <div class="col-12 col-md-6">
                            <label for="validUntil">Valid Until</label>
                            <input type="date" name="validUntil" id="validUntil" value="<?php if ($forUpdate) {
                                                                                            echo $discount['valid_until'];
                                                                                        } ?>" class="form-control">
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>

                    <?php if ($forUpdate) { ?>
                        <button type="submit" class="btn btn-primary" onclick="UpdateDiscount()">Update</button>
                    <?php } else { ?>
                        <button type="submit" class="btn btn-primary" onclick="AddDiscount()">Add</button>
                    <?php } ?>

                </div>
            </div>
            <!-- </form> -->
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {
        loadSelect2(['#packageName'], '.modal-body');
        
        function calculateAfterDiscount() {
            var amount = $('#packageName option:selected').data('package-amount');
            var discount = parseInt($('#discountAmount').val()) || 0;

            var afterDiscount = amount - discount;

            $('#afterDiscount').val(afterDiscount);
        }

        $('#packageName, #discountAmount').on('change input', function() {
            calculateAfterDiscount();
        });

        calculateAfterDiscount();
    });
</script>