<?php
include('../db/model.php');
include('../config/config.php');
$db = new Model();

$billNumber = null;

if (isset($_POST['billNumber'])) {
    $billNumber = $_POST['billNumber'];
}

?>

<div class="modal fade" id="modalModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
    aria-labelledby="modalModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header text-center">
                <h1 class="modal-title w-100" id="modalModalLabel">ADD EVENT IN BILL</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <div id="custom-form-dark">
                <div class="modal-body">
                    <input type="hidden" name="mBillNumber" id="mBillNumber" value="<?php echo $billNumber; ?>">

                    <div class="row">
                        <div class="col-12 mb-3">
                            <label for="" class="form-label fs-5">Bill Number:
                                <?php echo InvoicePrefix::BILL_NUMBER . $billNumber ?></label>
                        </div>
                    </div>

                    <div class="row">
                        <div class="input-group mb-3">
                            <span class="input-group-text btn-light fw-bold">Event ID</span>
                            <input type="text" class="form-control bg-dark text-light text-center"
                                id="mSearchEventTextBox">
                            <button class="btn btn-sm btn-light" id="mSearchAddEventBtn" onclick="addAnotherEvent()"><i
                                    class="bi bi-search"></i></button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="modal-footer bg-dark">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        $('#modalModal').on('shown.bs.modal', function () {
            $('#mSearchEventTextBox').trigger('focus');
        });

        $('#mSearchEventTextBox').on('keydown', function (e) {
            if (e.key === 'Enter') {
                e.preventDefault();
                addAnotherEvent();
            }
        });
    });
</script>