$(document).ready(function() {
  table = $('#dataTable').DataTable({
      order: [],
      ajax: {
          url: 'event_type.php',
          type: 'POST',
          data: {
              type: 'list'
          },
          dataSrc: function(json) {
              return json;
          },
      },
      columns: [{
              data: 'name'
          },
          {
              data: null,
              render: function(data) {
                return sStatus(data['status']);
              }
          },
          {
              data: null,
              render: function(data, type, row) {
                  var btn = '<div class="text-center"><div class="btn-group">';
                  btn += '<button type="button" class="btn btn-sm action-btn" onclick="DetailEventType(' + row.id + ')"><i class="bi bi-pencil-fill"></i></button>';
                  btn += '</div></div>';
                  return btn;
              }
          }
      ]
  });
});

function DetailEventType(id) {
  $.ajax({
    type: "post",
    url: "modal_event_type.php",
    data: {
      id: id,
    },
    success: function (sData) {
      $("#modalDiv").html("");
      $("#modalDiv").append(sData);
      $("#modalModal").modal("show");
    },
  });
}

function AddEventType() {
  var name = $("#name").val();
  var status = document.getElementById('eventTypeStatusActive').checked ? 1 : 0;

  if (name === "" || name === null) {
    $("#name").css("border-color", "red");
    return;
  }

  $.ajax({
    type: "post",
    url: "modal_event_type.php",
    data: {
      type: "add",
      name: name,
      status: status
    },
    success: function (response) {
      if (response.success) {
        $("#modalModal").modal("hide");
        table.ajax.reload();
        swal(response.message, {
          icon: "success",
        });
      } else {
        swal('Error: ' + response.message, {
          icon: "error",
        });
      }
    },
  });
}

function UpdateEventType() {
  var id = $("#id").val();
  var name = $("#name").val();
  var status = document.getElementById('eventTypeStatusActive').checked ? 1 : 0;

  if (name === "" || name === null) {
    $("#name").css("border-color", "red");
    return;
  }

  swal({
    title: "Are you sure?",
    text: "Update this event type!",
    icon: "warning",
    buttons: true,
    dangerMode: true,
  }).then((willDelete) => {
    if (willDelete) {
      $.ajax({
        type: "post",
        url: "modal_event_type.php",
        data: {
          type: "update",
          id: id,
          name: name,
          status: status
        },
        success: function (response) {
          if (response.success) {
            $("#modalModal").modal("hide");
            table.ajax.reload();
            swal(response.message, {
              icon: "success",
            });
          } else {
            swal('Error: ' + response.message, {
              icon: "error",
            });
          }
        },
      });
    }
  });
}