<?php
$_page_title = "Generate";
$_main_root = '../';

require_once $_main_root . 'db/model.php';

$db = new Model();
$billMst = null;
$billDtl = null;

if (isset($_POST['type'])) {
    header('Content-Type: application/json');

    if ($_POST['type'] == "find") {
        $eventId = (int) ($_POST['eventId'] ?? 0);
        $billNum = (int) ($_POST['billNum'] ?? 0);

        $billMst = null;

        if ($eventId > 0) {
            $billMst = $db->GetBillMst(false,$eventId, false);
        } elseif ($billNum > 0) {
            $billMst = $db->GetBillMst(false,$billNum);
        }

        if ($billMst) {
            $billNumber = $billMst['bill_num'];
            $billDtl = $db->GetBillDtlByBillNumber($billNumber);
            echo json_encode(['billMst' => $billMst, 'billDtl' => $billDtl]);
        } else {
            echo json_encode(['bill' => false]);
        }

        exit;
    }

    if ($_POST["type"] == "mstUp") {
        $result = $db->UpdateBillMst($_POST);
        echo json_encode(['flag' => $result]);
        exit;
    }

    if ($_POST["type"] == "db") {
        $result = $db->DeleteBill($_POST);
        echo json_encode(['flag' => $result]);
        exit;
    }

}

include($_main_root . 'content/common/header.php');

if (!Permission()) {
    return;
}
?>

<!-- modal -->
<div id="modalDiv"></div>

<div class="container container-fluid">
    <input type="hidden" name="hBillNum" id="hBillNum" value="">
    <div class="my-4 d-flex justify-content-between align-items-center">
        <h2 style="color:var(--s-text-color);">PROCESS CUSTOMER BILL</h2>
        <div>
            <a href="cust_bill_collection.php" class="btn btn-sm btn-outline-info ms-3 fw-bold"><i class="bi bi-credit-card me-2"></i> BILL PAYMENT</a>
        </div>
    </div>

    <div class="row my-4">
        <div class="card bg-dark" style="border-color: var(--s-text-color);">
            <div class="card-body text-white">
                <div class="d-flex justify-content-between align-items-center">
                    <h2 style="color:var(--s-text-color);">Bill Details</h2>
                    <div>
                        <div class="input-group mb-3">
                            <span class="input-group-text btn-light fw-bold" id="searchEventId">
                                <div class="input-group text-center">
                                    <input type="radio" name="searchBill" id="eventIdSearch" class="me-1" checked>
                                    <label for="eventIdSearch" class="me-3">Event ID</label>
                                    <input type="radio" name="searchBill" id="billNumSearch" class="me-1">
                                    <label for="billNumSearch" class="">Bill Number</label>
                                </div>
                            </span>
                            <input type="text" class="form-control bg-dark text-light text-center"
                                id="searchEventTextBox">
                            <button class="btn btn-sm btn-light" id="searchEventBtn"><i
                                    class="bi bi-search"></i></button>
                        </div>
                    </div>
                </div>

                <div class="row my-3 justify-content-center">
                    <div class="col-12 col-md-6">
                        <table class="table table-sm table-dark border border-dark fs-5 w-100">
                            <thead>
                                <tr>
                                    <th style="width: 110px;"></th>
                                    <th style="width: 5px;"></th>
                                    <th></th>
                                    <th style="width: 110px;"></th>
                                    <th style="width: 5px;"></th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>
                                <tr>
                                    <td>Bill Number</td>
                                    <td>:</td>
                                    <td class="fw-bold" id="billNumber"><?php echo InvoicePrefix::BILL_NUMBER; ?></td>
                                    <td>Bill Amount</td>
                                    <td>:</td>
                                    <td class="fw-bold" id="billAmount">0</td>
                                </tr>
                                <tr>
                                    <td>Discount</td>
                                    <td>:</td>
                                    <td class="fw-bold">
                                        <input type="text" name="billDiscount" id="billDiscount" value="0" onfocus="this.select()"
                                            style="border-bottom:1px solid var(--s-text-color-2) !important;"
                                            class="form-control bg-dark border border-dark text-light fw-bold p-0 fs-5">
                                    </td>
                                    <td>Payable</td>
                                    <td>:</td>
                                    <td class="fw-bold" id="billPayable">0</td>
                                </tr>
                                <tr>
                                    <td>Biller Name</td>
                                    <td>:</td>
                                    <td class="fw-bold" colspan="4">
                                        <input type="text" name="billerName" id="billerName" value="..." onfocus="this.select()"
                                            style="border-bottom:1px solid var(--s-text-color-2) !important;"
                                            class="form-control bg-dark border border-dark text-light fw-bold p-0 fs-5">
                                    </td>
                                </tr>
                                <tr id="actionButton"></tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="row justify-content-center mb-4">
                    <div class="table-responsive-lg">
                        <table id="dataTable" class="table table-sm table-dark table-hover table-bordered"
                            style="width: 100%;">
                            <thead style="color:var(--s-text-color);" class="mt-3">
                                <th style="width: 50px;">E.ID</th>
                                <th style="width: 100px;">Event Date</th>
                                <th>Add Ons</th>
                                <th style="width: 150px;">Add Time</th>
                                <th style="width: 150px;">Package Amount</th>
                                <th style="width: 50px;">Total</th>
                                <th style="width: 100px">Action</th>
                            </thead>
                            <tbody class="text-center">
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $s_scripts = ['cust_bill']; ?>
<?php include($_main_root . 'content/common/footer.php'); ?>