$(document).ready(function () {
    YearMonthList();
});

$("#year-month-btn").on('click', function () { 
    YearMonthList();
 });

$("#all-btn").on('click', function () { 
    AllList();
 });

$("#no-booked-btn").on('click', function () { BookedList(); });

function btn(button) { 
    var yearMonthBtn = document.querySelector("#year-month-btn");
    var allBtn = document.querySelector("#all-btn");
    var bookedBtn = document.querySelector("#no-booked-btn");

    yearMonthBtn.classList.remove("btn-success");
    allBtn.classList.remove("btn-success");
    bookedBtn.classList.remove("btn-success");

    yearMonthBtn.classList.add("btn-outline-success");
    allBtn.classList.add("btn-outline-success");
    bookedBtn.classList.add("btn-outline-success");

    switch (button) {
        case "year-month-btn":
            yearMonthBtn.classList.remove("btn-outline-success");
            yearMonthBtn.classList.add("btn-success");
            break;
        case "all-btn":
            allBtn.classList.remove("btn-outline-success");
            allBtn.classList.add("btn-success");
            break;
        case "no-booked-btn":
            bookedBtn.classList.remove("btn-outline-success");
            bookedBtn.classList.add("btn-success");
            break;
        default:
            yearMonthBtn.classList.remove("btn-outline-success");
            yearMonthBtn.classList.add("btn-success");
    }
}

function YearMonthList() {
    btn("year-month-btn");
    $('#reportTitle').html('Year Month Group');

    $("#reportBody").html('');

    $.ajax({
        type: "post",
        url: "cust_quotation_list_group.php",
        success: function (response) {
            $("#reportBody").append(response);
        }
    });
}

function AllList() {
    btn("all-btn");
    $('#reportTitle').html('All Quotations');

    $("#reportBody").html('');

    $.ajax({
        type: "post",
        url: "cust_quotation_list_all.php",
        success: function (response) {
            $("#reportBody").append(response);
        }
    });
}

function BookedList() {
    btn("no-booked-btn");
    $('#reportTitle').html('No Booked Event; Quotations');

    $("#reportBody").html('');

    $.ajax({
        type: "post",
        url: "cust_quotation_list_no_booked.php",
        success: function (response) {
            $("#reportBody").append(response);
        }
    });
}