<?php
$_main_root = '../';
require_once $_main_root . 'db/model.php';

$db = new Model();
if (isset($_POST['type'])) {
    header('Content-Type: application/json');

    if ($_POST['type'] == "list") {
        $list = $db->GetQuotation('nbl');
        echo json_encode($list);
    } elseif ($_POST['type'] == "d") {
        $flag = $db->QuotationDelete(true, $_POST['id']);
        echo json_encode($flag);
    } elseif ($_POST['type'] == "make_event") {
        $flag = $db->UpdateQuotationMst($_POST);
        echo json_encode($flag);
    }
    exit;
}

?>

<div class="table-responsive">
    <table id="tableQuote" class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">
        <thead style="color:var(--s-text-color);" class="mt-3">
            <th style="width: 50px;">#</th>
            <th style="">Client Name</th>
            <th style="">Purpose</th>
            <th style="">Amount</th>
            <th style="">Discount</th>
            <th style="">After Disc</th>
            <th style="width: 5px;">Action</th>
        </thead>
        <tbody></tbody>
    </table>
</div>

<script>
    $(document).ready(function () {
        table = $('#tableQuote').DataTable({
            order: [],
            ajax: {
                url: 'cust_quotation_list_no_booked.php',
                type: 'POST',
                data: {
                    type: 'list'
                },
                dataSrc: function (json) {
                    return json;
                },
            },
            columns: [
                {
                    data: null,
                    render: function (data, type, row) {
                        var btn = `<div class="form-check" id="custom-form-dark">
                                        <input class="form-check-input make_event" type="checkbox" id="make_event${row.id}" data-id="${row.id}" value="${row.make_event}" title="Book Event" ${(row.make_event == 1) ? 'checked' : ''}>
                                        <label class="form-check-label" for="make_event${row.id}">${row.id}</label>
                                    </div>`;
                        return btn;
                    }
                },
                { data: 'client_name' },
                { data: 'purpose' },
                { data: 'amount' },
                { data: 'discount' },
                { data: 'total_amt' },
                {
                    data: null,
                    render: function (data, type, row) {
                        var btn = `<div class="btn-group">

                    ${sAccess(se) ? `<button type="button" class="btn btn-sm action-btn" id="quote-edit" data-quote_id=${row.id} data-event="${row.make_event}"><i class="bi bi-pencil-square"></i></button>` : ``}

                    ${sAccess(sd) ? `<button class="btn btn-sm action-btn quote-delete" data-quote_id="${row.id}" data-event="${row.make_event}"><i class="bi bi-trash-fill"></i></button>` : ``}

                    <a href="../print/cust_quotation.php?quote_id=${row.id}" class="btn btn-sm action-btn" target="_blank"><i class="bi bi-printer-fill"></i></a>
                    </div>`;
                        return btn;
                    }
                }
            ],
            columnDefs: [
                { targets: 3, className: 'dt-center' },
                { targets: 4, className: 'dt-center' },
                { targets: 5, className: 'dt-center' },
                { targets: 6, className: 'dt-center' },
            ]
        });

        $(document).on('click', '.quote-delete', function () {
            var quote_id = $(this).data('quote_id');
            var event = $(this).data('event');

            if (event == 1) {
                sAlert("This quotation is final for the book event.", "Event already booked!", "error");
            } else {
                sAlertConfirm(() => {
                    $.ajax({
                        type: "post",
                        url: "cust_quotation_list_all.php",
                        data: {
                            type: "d",
                            id: quote_id
                        },
                        dataType: "json",
                        success: function (response) {
                            sAlert("Quotation Deleted");
                            $('#tableQuote').DataTable().ajax.reload();
                        }
                    });
                }, "delete")
            }
        });

        $(document).on('click', "#quote-edit", function () {
            var quote_id = $(this).data('quote_id');
            var event = $(this).data('event');
            if (event == 1) {
                sAlert("This quotation is final for the book event.", "Event already booked!", "error");
            } else {
                var pageLink = baseUrl + 'content/cust_quotation.php';
                sShowPage(pageLink, quote_id)
            }
        });

        $(document).on("click", ".make_event", function () {
            var id = $(this).data('id');
            var value = $(this).val();
            var data = (value == 0 ? 1 : 0);
            var title = "Are you sure? " + (value == 1 ? "Update this record." : "This quotation is already booked for the event.");
            sAlertConfirm(() => {
                $.ajax({
                    type: "post",
                    url: "cust_quotation_list_all.php",
                    data: {
                        type: "make_event",
                        id: id,
                        make_event: data
                    },
                    dataType: "json",
                    success: function (response) {
                        table.ajax.reload();
                    }
                });
            }, 'update', title);

            $(this).prop('checked', value == 1);
        });

    });
</script>