<?php

class DbModel
{
    private string $host = 'localhost';
    private string $user = 'snapyquo_snapmome_azizul';
    private string $pass = 'e{{yz6VX,sB7';
    private string $database = 'snapyquo_events_management';

    public mysqli $conn;

    public function __construct()
    {
        
        try {
            $this->conn = new mysqli($this->host, $this->user, $this->pass, $this->database);

            $this->conn->set_charset('utf8mb4');

            if ($this->conn->connect_errno) {
                die('Connection Failed: ' . $this->conn->connect_error);
            }
        } catch (\mysqli_sql_exception $e) {
            die('Connection Failed: ' . $e->getMessage());
        }
    }

    protected function Exists(string $sql)
    {
        $result = $this->conn->query($sql);

        if (!$result) {
            error_log("SQL Error (Exists): " . $this->conn->error . " | SQL: " . $sql);
            return false;
        }

        $num_rows = $result->num_rows;
        $result->free();

        return $num_rows > 0;
    }

    protected function FetchAllAssoc(string $sql)
    {
        $data = [];
        $result = $this->conn->query($sql);

        if (!$result) {
            error_log("SQL Error (FetchAllAssoc): " . $this->conn->error . " | SQL: " . $sql);
            return $data;
        }

        while ($row = $result->fetch_assoc()) {
            $data[] = $row;
        }

        $result->free();
        return $data;
    }

    protected function FetchOneAssoc(string $sql)
    {
        $result = $this->conn->query($sql);

        if (!$result) {
            error_log("SQL Error (FetchOneAssoc): " . $this->conn->error . " | SQL: " . $sql);
            return null;
        }

        if ($result->num_rows === 1) {
            $row = $result->fetch_assoc();
            $result->free();
            return $row;
        }

        $result->free();
        return null;
    }

    protected function FetchSingleValue(string $sql, bool $returnInt = false)
    {
        $result = $this->conn->query($sql);

        if (!$result) {
            error_log("SQL Error (FetchSingleValue): " . $this->conn->error . " | SQL: " . $sql);
            return $returnInt ? 0 : "";
        }

        if ($row = $result->fetch_row()) {
            $data = $row[0];
            $result->free();
            return $returnInt ? (int) $data : (string) $data;
        }

        $result->free();
        return $returnInt ? 0 : "";
    }

    protected function ExecuteStatement(string $sql, bool $insertId = false, bool $affectedRows = false)
    {
        $result = $this->conn->query($sql);

        if ($result === true) {
            if ($insertId) {
                return $this->conn->insert_id;
            }

            if ($affectedRows) {
                return $this->conn->affected_rows;
            }

            return true;
        }

        error_log("SQL Error (ExecuteStatement): " . $this->conn->error . " | SQL: " . $sql);
        return false;
    }

    protected function SanitizeString(string $string){
        return $this->conn->real_escape_string($string);
    }
}