<?php
include('../db/model.php');
include('../config/config.php');
$db = new Model();
// $tableHeight='';
$forUpdate=false;
$id=0;
$role = $db->GetUserRole();

if (isset($_POST['id']) && is_numeric($_POST['id'])) {
    $id = (int)$_POST['id'];
    $forUpdate = $id > 0;
}

if ($id!=0 || $id!='') {
    $user = $db->GetUser($id, "id");
}

if ($_POST['type']=='add') {
    $db->AddUser($_POST);
}
else if ($_POST['type']=='update') {
    $db->UpdateUser($_POST);
}

?>
    <div class="modal fade" id="userModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="userModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header text-center">
                    <h1 class="modal-title fs-5 w-100" id="userModalLabel"><?php if($forUpdate){echo 'Update User';}else{echo 'Add New User';} ?></h1>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                
                <div id="custom-form-light">
                    <div class="modal-body">
                    
                        <input type="hidden" name="mId" id="mId" value="<?php if($forUpdate){echo $user['id'];} ?>">

                        <div class="mb-3">
                            <label for="mUserName">User Name</label>
                            <input type="text" name="mUserName" id="mUserName" value="<?php if($forUpdate){echo $user['username'];} ?>" <?php if($forUpdate){echo 'readonly';} ?> class="form-control">
                        </div>
                        <div class="mb-3">
                            <label for="mFullName">Full Name</label>
                            <input type="text" name="mFullName" id="mFullName" value="<?php if($forUpdate){echo $user['full_name'];} ?>" class="form-control">
                        </div>
                        <div class="mb-3">
                            <label for="mPassword">Password</label>
                            <input type="password" name="mPassword" id="mPassword" value="" class="form-control">
                        </div>

                        <div class="input-group">     
                            <div class="col-12 col-sm-12 col-md-6 mb-3 pe-md-2">
                                <label for="role">User Type</label>
                                <select name="role" id="role" class="form-control form-select">
                                    <?php foreach ($role as $row){ ?>
                                        <option value="<?= $row['id'] ?>" <?php if($user){ echo ($user['role_id'] == $row['id']) ? 'selected' : '';} ?>>
                                            <?= $row['name'] ?>
                                        </option>
                                    <?php } ?>
                                </select>
                            </div>

                            <div class="col-12 col-sm-12 col-md-6 mb-3 ms-auto me-0 ps-md-2">
                                <label for="mUserStatus">User Status</label>
                                <div class="input-group">
                                    <div class="form-check ps-5">
                                        <input class="form-check-input" type="radio" name="mUserStatus" id="mUserStatusActive"  <?php if($forUpdate){if($user['status']==1){echo 'checked';}}?>>
                                        <label class="form-check-label" for="mUserStatusActive">
                                            Active
                                        </label>
                                        </div>
                                    <div class="form-check ps-5">
                                        <input class="form-check-input" type="radio" name="mUserStatus" id="mUserStatusDeActive" <?php if($forUpdate){if($user['status']==0){echo 'checked';}}?>>
                                        <label class="form-check-label" for="mUserStatusDeActive">
                                            De-Active
                                        </label>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="modal-footer">
                        <div class="validationErrorMsg"></div>

                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        
                        <?php if($forUpdate){?>
                            <button type="submit" name="payment" class="btn btn-primary" onclick="UpdateUser()">Update</button>
                        <?php }else{ ?>
                            <button type="submit" name="payment" class="btn btn-primary" onclick="AddUser()">Add</button>
                        <?php } ?>

                    </div>
                </div>
                <!-- </form> -->
            </div>
        </div>
    </div>