<?php
$_main_root = '../';
require_once $_main_root . 'db/model.php';

$db = new Model();
if (isset($_POST['type'])) {
    header('Content-Type: application/json');

    if ($_POST['type'] == "list") {
        $list = $db->GetQuotation('ym');
        echo json_encode($list);
    } elseif ($_POST['type'] == "dtlList") {
        $list = $db->GetQuotationDetails($_POST, false, false, true);
        echo json_encode($list);
    }
    exit;
}

?>

<div class="table-responsive">
    <table id="tableQuote" class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">
        <thead style="color:var(--s-text-color);" class="mt-3">
            <th style="">Year and Month</th>
            <th style="width: 200px">Total Event</th>
        </thead>
        <tbody></tbody>
    </table>
</div>

<script>
    $(document).ready(function () {
        table = $('#tableQuote').DataTable({
            order: [],
            ajax: {
                url: 'cust_quotation_list_group.php',
                type: 'POST',
                data: {
                    type: 'list'
                },
                dataSrc: function (json) {
                    return json;
                },
            },
            columns: [
                {
                    data: null,
                    render: function (data, type, row) {
                        var year = row.event_year;
                        var monthName = monthsNameFull[row.event_month - 1];
                        var arrowBtn = '<i class="ms-2 toggle-arrow bi bi-chevron-down"></i> ';
                        return arrowBtn + year + ' - ' + monthName;
                    }
                },
                { data: 'total_event' }
            ],
            columnDefs: [
                { targets: 1, className: 'dt-center' }
            ]
        });

        $('#tableQuote tbody').on('click', 'tr', function () {
            var tr = $(this);
            var row = table.row(tr);

            if (row.child.isShown()) {
                row.child.hide();
                tr.find('.toggle-arrow').removeClass('bi-chevron-up').addClass('bi-chevron-down');
                return;
            }

            var data = row.data();

            var childContent = `
                        <table class="table table-sm table-dark table-bordered mb-0" id="sub-table" style="color:var(--s-text-color-2);">
                            <thead class="table-secondary">
                                <tr>
                                    <th style="width: 10px;">#</th>
                                    <th style="width: 10px;">Id</th>
                                    <th style="width: 30px;">Q. Id</th>
                                    <th style="width: 100px;">Event Date</th>
                                    <th>Package</th>
                                    <th>Event Type</th>
                                    <th style="">Location</th>
                                    <th style="width: 80px;">Amount</th>
                                    <th style="width: 80px;">Adjust</th>
                                    <th style="width: 80px;">Total</th>
                                </tr>
                            </thead>
                            <tbody class="text-info">`;
            $.ajax({
                url: 'cust_quotation_list_group.php',
                type: 'POST',
                data: {
                    type: 'dtlList',
                    event_year: data['event_year'],
                    event_month: data['event_month'],
                },
                success: function (response) {
                    response.forEach(function (dtl, index) {
                        var packageName = dtl.package_name + ( sInt(dtl.add_ons_amt) > 0 ? " + Add-Ons":"");
                        var amount = sInt(dtl.package_amt) + sInt(dtl.out_amt) + sInt(dtl.add_ons_amt);
                        childContent += `
                                    <tr>
                                        <td class="text-center">${index + 1}</td>
                                        <td class="text-center">${dtl.id}</td>
                                        <td class="text-center">${dtl.mst_id}</td>
                                        <td class="text-center">${sDate(dtl.event_date)}</td>
                                        <td class="text-start">${packageName}</td>
                                        <td class="text-start">${dtl.event_type}</td>
                                        <td class="text-start">${dtl.location}</td>
                                        <td class="text-end">${amount}</td>
                                        <td class="text-end">${dtl.adjust_amt}</td>
                                        <td class="text-end">${dtl.total}</td>
                                    </tr>
                                `;
                    });
                    childContent += `</tbody>
                        </table>`;

                    row.child(childContent).show();
                }
            });

            // tr.addClass('shown');
            tr.find('.toggle-arrow').removeClass('bi-chevron-down').addClass('bi-chevron-up');
        });
    });
</script>