<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

class Enum
{


}

class EventStatus
{
    // Define possible status values
    const OPEN = 'open';
    const COMPLETED = 'completed';
    const CANCELLED = 'cancelled';
    const POSTPONED = 'postponed';

    // Return an associative array of status => human-readable label
    public static function StatusLabel(): array
    {
        return [
            self::OPEN => 'Open',
            self::COMPLETED => 'Completed',
            self::CANCELLED => 'Cancelled',
            self::POSTPONED => 'Postponed'
        ];
    }

    // Optional: Validate if a status is valid
    public static function IsValid(string $status): bool
    {
        return array_key_exists($status, self::StatusLabel());
    }
}

class InvoicePrefix
{
    public const EVENT_PAY = '#INV-';
    public const EMP_PAY = '#E-INV-';
    public const BILL_NUMBER = "B-";
}

class User
{
    public static function Login(): ?bool
    {
        return $_SESSION['login'] ?? false;
    }

    public static function UserName(): ?string
    {
        return $_SESSION['username'] ?? null;
    }

    public static function FullName(): ?string
    {
        return $_SESSION['fullName'] ?? null;
    }

    public static function UserRole(): ?string
    {
        return $_SESSION['role'] ?? null;
    }
}

class Payment
{
    private const Cash = 'Cash';
    private const BankTransfer = 'Bank Transfer';
    private const MobileBanking = 'Mobile Banking';
    private const Cheque = 'Cheque';
    private const Discount = 'Discount';

    // Optional: Validate if a status is valid
    public static function Method(string $status)
    {
        $payMethodArr = [
            self::Cash,
            self::BankTransfer,
            self::MobileBanking,
            self::Cheque,
            self::Discount
        ];

        $statusLower = strtolower($status);

        foreach ($payMethodArr as $method) {
            if (strtolower($method) === $statusLower) {
                return $method;
            }
        }

        return self::Cash;

    }

}


if (isset($_GET['json'])) {
    header('Content-Type: application/json');
    echo json_encode([
        'InvoicePrefix' => [
            'EVENT_PAY' => InvoicePrefix::EVENT_PAY,
            'EMP_PAY' => InvoicePrefix::EMP_PAY,
            'BILL_NUMBER' => InvoicePrefix::BILL_NUMBER,
        ],
        'EventStatus' => EventStatus::StatusLabel(),
        'User' => [
            'UserName' => User::UserName(),
            'FullName' => User::FullName(),
            'UserRole' => User::UserRole(),
            'Login' => User::Login()
        ]
    ]);
    exit;
}