<?php
$_main_root = '../';
include($_main_root . "db/model.php");
include($_main_root . "config/config.php");
$db = new Model();
$pay = null;
$billAmt = 0;
$paySum = 0;
$due = 0;

if (isset($_GET["invoice"])) {
	$invoiceNo = $_GET["invoice"];
	$pay = $db->GetBillPayByInvoice($invoiceNo, true);
	$billMst = $db->GetBillMst(false,$pay["bill_num"]);
	$billAmt = (int) ($billMst["ttl_bill_amt"] ?? 0);
	$paySum = $db->GetBillPayByBillNum($pay["bill_num"], true, false, true);

	$due = $billAmt - $paySum;
}

?>

<!DOCTYPE html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="stylesheet" href="<?php echo $_main_root; ?>vendor/bootstrap-5.3.0/css/bootstrap.min.css">
	<title><?= $pay["received_from"]. '_Money Receipt' ?></title>

	<style>
		body {
			font-family: 'Times New Roman', Times, serif;
			margin: 0;
			padding: 0;
			background: #fff;
		}

		.print-area {
			height: 5in;
			box-sizing: border-box;
			display: flex;
			flex-direction: column;
			page-break-after: always;
		}

		@media print {
			@page {
				size: A4 portrait;
				margin: 0;
			}

			body * {
				visibility: hidden;
			}

			.print-area,
			.print-area * {
				visibility: visible;
			}
		}
	</style>
</head>

<body>

	<div class="print-area m-5 p-2 border border-dark">
		<div class="text-end"><label for="">Client Copy</label></div>

		<div class="my-3 mx-5">
			<div class="row align-items-center">
				<div class="col-6 text-center">
					<img src="logo.png" width="200" alt="SnapMoment Logo" />
				</div>
				<div class="col-6 text-center">
					<h3 class="m-0"><strong>MONEY RECEIPT</strong></h3>
				</div>
			</div>

			<table class="table table-borderless w-100 mt-5">
				<thead>
					<tr>
						<td class="" style="width: 120px;"></td>
						<td class="" style=""></td>
						<td class="" style="width: 90px;"></td>
						<td class="" style=""></td>
					</tr>
				</thead>
				<tbody>
					<tr class="">
						<td class="p-0 pe-1 text-end" style="max-width: 5px;">Date :</td>
						<td class="p-0">
							<label
								class="w-100 pb-1 px-1 border-bottom fw-bold"><?= ($pay) ? sDate($pay["payment_date"]) : ""; ?></label>
						</td>
						<td class="p-0 pe-1 text-end" style="max-width: 5px;">Receipt No :</td>
						<td class="p-0">
							<label
								class="w-100 pb-1 px-1 border-bottom fw-bold"><?= ($pay) ? InvoicePrefix::EVENT_PAY . $pay["invoice"] : ""; ?></label>
						</td>
					</tr>
					<tr class="">
						<td class="p-0 pt-2 pe-1 text-end" style="max-width: 5px;">Received From :</td>
						<td class="p-0 pt-2">
							<label
								class="w-100 pb-1 px-1 border-bottom fw-bold"><?= ($pay) ? $pay["received_from"] : ""; ?></label>
						</td>
						<td class="p-0 pt-2 pe-1 text-end" style="max-width: 5px;">Amount :</td>
						<td class="p-0 pt-2">
							<label
								class="w-100 pb-1 px-1 border-bottom fw-bold"><?= ($pay) ? sTakaFormat($pay["payment_amt"], false, true) : ""; ?></label>
						</td>
					</tr>
					<tr class="">
						<td class="p-0 pt-2 pe-1 text-end" style="max-width: 5px;">For :</td>
						<td class="p-0 pt-2">
							<label
								class="w-100 pb-1 px-1 border-bottom fw-bold"><?= ($pay) ? InvoicePrefix::BILL_NUMBER . $pay["bill_num"] : ""; ?></label>
						</td>
						<td class="p-0 pt-2 pe-1 text-end" style="max-width: 5px;">Paid By :</td>
						<td class="p-0 pt-2">
							<label
								class="w-100 pb-1 px-1 border-bottom fw-bold"><?= ($pay) ? $pay["pay_method"] : ""; ?></label>
						</td>
					</tr>
					<tr class="">
						<td class="p-0 pt-2 text-end" style="max-width: 5px;">Received By:</td>
						<td class="p-0 pt-2">
							<label class="w-100 pb-1 px-1 border-bottom fw-bold"><?= ($pay) ? $pay["received_by"] : ""; ?></label>
						</td>
						<td class="p-0 pt-2 text-end" style="max-width: 5px;"></td>
						<td class="p-0 pb-3 text-center align-bottom" rowspan="2">
							<div>
								<img src="raihan_signature.jpg" alt="" width="110">
							</div>
						</td>
					</tr>
					<tr class="">
						<td class="p-0 ps-5 pt-3" style="max-width: 5px;" colspan="2">
							<table class="table" style="border: 1px solid #07305d;">
								<tr>
									<td class="p-0 pe-1 text-end" style="border-right: 1px solid #07305d;">Total Amount Due :</td>
									<td class="p-0 text-center fw-bold"><?= sTakaFormat($billAmt, false, true); ?></td>
								</tr>
								<tr>
									<td class="p-0 pe-1 text-end" style="border-right: 1px solid #07305d;">Total Amount Received :</td>
									<td class="p-0 text-center fw-bold"><?= sTakaFormat($paySum,false, true); ?></td>
								</tr>
								<tr>
									<td class="p-0 pe-1 text-end text-white" style="background-color: #07305d">Balance Amount :</td>
									<td class="p-0 text-center fw-bold text-white" style="background-color: #07305d;"><?= sTakaFormat($due, false, true); ?></td>
								</tr>
							</table>
						</td>
						<td class="p-0" style="max-width: 5px;">
							<div>
								<?= ($due > 0)? '' : '<img src="paid.png" alt="" width="90">'; ?>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
		</div>


	</div>

</body>

</html>