<?php
require_once('../config/config.php');
require_once('../db/model.php');

$db = new Model();

$data = $db->GetEventById($id);
$addOnsList = $db->GetEventAddOns($data["id"], "ei");
$eventTypeId = (int) ($data["event_type_id"] ?? 0);
$packageId = (int) ($data["package_id"] ?? 0);
?>

<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Booking Information</title>
    <style>
        body {
            margin: 0;
            padding: 0;
            background-color: #f3f3f3;
        }

        .snap-wrapper {
            max-width: 650px;
            margin: 0 auto;
            background-color: #fff;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }

        .snap-header {
            background-color: #111;
            color: #f4c542;
            padding: 20px;
            text-align: center;
        }

        .snap-header h1 {
            margin: 0;
            font-size: 28px;
            letter-spacing: 1px;
        }

        .snap-content {
            padding: 30px 20px;
            color: #333;
        }

        .snap-content h2 {
            margin-top: 0;
            color: #222;
        }

        .snap-booking-info {
            margin-top: 20px;
            border: 1px solid silver;
            border-radius: 8px;
            overflow: hidden;
        }

        .snap-row {
            display: flex;
            padding: 10px 15px;
            background-color: #fdfdfd;
            border-bottom: 1px solid silver;
        }

        .snap-row:nth-child(even) {
            background-color: #f9f9f9;
        }

        .snap-label {
            width: 45%;
            font-weight: bold;
            color: black;
        }

        .snap-value {
            width: 55%;
            color: black;
        }

        .snap-cta {
            margin-top: 30px;
            background-color: #fef6e8;
            padding: 20px;
            border-left: 4px solid #f4c542;
            border-radius: 6px;
        }

        .snap-cta strong {
            color: #b17e00;
        }

        .snap-footer {
            background-color: #111;
            color: silver;
            text-align: center;
            padding: 20px;
            font-size: 14px;
        }

        .snap-footer a {
            color: #f4c542;
            text-decoration: none;
        }

        @media only screen and (max-width: 600px) {
            .snap-row {
                display: block;
            }

            .snap-label,
            .snap-value {
                width: 100%;
                display: block;
                padding: 5px 0;
            }
        }
    </style>
</head>

<body>
    <div class="snap-wrapper">
        <div class="snap-header">
            <img src="<?= BASE_URL.'img/logo.png' ?>" alt="Snap Moment" width="250">
        </div>

        <div class="snap-content">
            <p>Dear <strong><?= $data["client_name"] ?></strong>,</p>
            <p>Thank you for choosing <strong>Snap Moment</strong> to capture your special memories. We are delighted to
                confirm that we have received your booking details as follows:</p>

            <div class="snap-booking-info">
                <div class="snap-row" style="background-color:silver; display: flex; text-align:center;">
                    <div style="width:100%; font-weight: bold;">BOOKING INFORMATION</div>
                </div>

                <div class="snap-row" id="booking_id">
                    <div class="snap-label">Booking ID</div>
                    <div class="snap-value"><?= $data["id"] ?></div>
                </div>
                <div class="snap-row" id="booking_date">
                    <div class="snap-label">Booking Date</div>
                    <div class="snap-value"><?= sDate($data["booking_date_time"], true, true) ?></div>
                </div>
                <div class="snap-row" id="event_date">
                    <div class="snap-label">Event Date</div>
                    <div class="snap-value"><?= sDate($data["event_date_time"], true, true) ?></div>
                </div>
                <div class="snap-row" id="client_name">
                    <div class="snap-label">Client's Name</div>
                    <div class="snap-value"><?= $data["client_name"] ?></div>
                </div>
                <div class="snap-row" id="contact_no">
                    <div class="snap-label">Contact No</div>
                    <div class="snap-value"><?= $data["phone"] ?></div>
                </div>
                <div class="snap-row" id="email">
                    <div class="snap-label">Email</div>
                    <div class="snap-value"><?= $data["email"] ?></div>
                </div>

                <?php if (EventFieldShow($eventTypeId, $packageId, 'event_type')) { ?>
                    <div class="snap-row" id="event_type">
                        <div class="snap-label">Event's Type</div>
                        <div class="snap-value"><?= $data["event_name"] ?></div>
                    </div>
                <?php } ?>
                <?php if (EventFieldShow($eventTypeId, $packageId, 'grom_name')) { ?>
                    <div class="snap-row" id="grom_name">
                        <div class="snap-label">Groom's Name</div>
                        <div class="snap-value"><?= $data["groom"] ?></div>
                    </div>
                <?php } ?>
                <?php if (EventFieldShow($eventTypeId, $packageId, 'bride_name')) { ?>
                    <div class="snap-row" id="bride_name">
                        <div class="snap-label">Bride's Name</div>
                        <div class="snap-value"><?= $data["bride"] ?></div>
                    </div>
                <?php } ?>
                <?php if (EventFieldShow($eventTypeId, $packageId, 'birthday_person_name')) { ?>
                    <div class="snap-row" id="birthday_person_name">
                        <div class="snap-label">Birthday Person's Name</div>
                        <div class="snap-value"><?= $data["birthday_person"] ?></div>
                    </div>
                <?php } ?>
                <?php if (EventFieldShow($eventTypeId, $packageId, 'org_name')) { ?>
                    <div class="snap-row" id="org_name">
                        <div class="snap-label">Organization's Name</div>
                        <div class="snap-value"><?= $data["org_name"] ?></div>
                    </div>
                <?php } ?>
                <?php if (EventFieldShow($eventTypeId, $packageId, '-')) { ?>
                    <div class="snap-row" id="package">
                        <div class="snap-label">Packages</div>
                        <div class="snap-value"><?= $data["package_name"] ?></div>
                    </div>
                <?php } ?>
                <?php if (EventFieldShow($eventTypeId, $packageId, 'add_ons')) { ?>
                    <div class="snap-row" id="add_ons">
                        <div class="snap-label">Add Ons</div>
                        <div class="snap-value">
                            <?php if ($addOnsList) {
                                foreach ($addOnsList as $row) {
                                    echo "<span class=''>" . '> '. $row['addons_name_qty'] . "</span><br>";
                                }
                            } ?>
                        </div>
                    </div>
                <?php } ?>
                <div class="snap-row" id="amount">
                    <div class="snap-label">Amount</div>
                    <div class="snap-value"><?= sTakaFormat($data["total_amt"], false, true) ?></div>
                </div>
                <div class="snap-row" id="location">
                    <div class="snap-label">Venue Location</div>
                    <div class="snap-value"><?= $data["venue"] ?></div>
                </div>
                <div class="snap-row" id="song">
                    <div class="snap-label">Song Preference</div>
                    <div class="snap-value"><?= $data["song"] ?></div>
                </div>
                <div class="snap-row" id="preference">
                    <div class="snap-label">Your Preference</div>
                    <div class="snap-value"><?= $data["preference"] ?></div>
                </div>
            </div>

            <div class="snap-cta">
                <p><strong>Payment Reminder:</strong></p>
                <p>To secure your booking, we kindly request a <strong>50% advance payment</strong> of the total package price for all events. The remaining balance will be due by the end of the final event day.</p>
                <p>Please make the advance payment at your earliest convenience to ensure your booking is fully confirmed.</p>
            </div>

            <div style="margin-top:30px;">If you have any questions or need assistance, feel free to contact us.</div>
            <div>We look forward to being a part of your special moments.</div>
            <div>Warm regards,</div>
            <div class=""><strong>Snap Moment Team</strong></div>
        </div>
        <div class="snap-footer">
            <a href="tel:+8801673157878">📞 01673157878 </a><br>
            📧 <a href="mailto:info@snapmomentbd.com">info@snapmomentbd.com</a> /
            <a href="mailto:snapmomentbd@gmail.com">snapmomentbd@gmail.com</a><br>
            🌐 <a href="https://snapmomentbd.com" target="_blank">snapmomentbd.com</a>
        </div>
    </div>
</body>

</html>