<?php
$_page_title = "Event List";
$_main_root = '../';
require_once $_main_root . 'db/model.php';
$db = new Model();

if (User::Login()) {
    $_login_page = false;
} else {
    $_login_page = true;
    $_public_form = true;
}

if (isset($_POST['type'])) {
    if ($_POST['type'] == "eventList") {
        $list = $db->EventList();
        header('Content-Type: application/json');
        echo json_encode($list);
        exit();
    }
}

include($_main_root . 'content/common/header.php');
?>

<div class="container container-fluid">
    <div class="my-4">
        <h2 style="color:var(--s-text-color);" class="text-center">EVENTS LIST</h2>
    </div>
    <div class="row justify-content-center my-4">
        <div class="table-responsive">
            <table id="dataTable" class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">
                <thead style="color:var(--s-text-color);" class="mt-3">
                    <th style="width: 5px;">ID</th>
                    <th style="width: 70px;">Booking Date</th>
                    <th style="width: 70px;">Event Date</th>
                    <th style="">Client Name</th>
                    <th style="">Client / Groom & Bride</th>
                    <th style="width: 5px;">Phone</th>
                    <th style="">Email</th>
                    <th style="">Package Name</th>
                    <th style="">Event Name</th>
                    <th style="">Venue</th>
                    <th style="">Photo Preferences</th>
                    <th style="">Song Preference</th>
                </thead>
                <tbody>
                </tbody>
            </table>

        </div>
    </div>
</div>

<!-- ============= Pending event list end ================ -->
<?php $s_scripts = ['payment']; ?>
<?php include($_main_root . 'content/common/footer.php'); ?>
<script>
    $(document).ready(function () {
        table = $('#dataTable').DataTable({
            order: [],
            autoWidth: false,
            ajax: {
                url: 'event_list.php',
                type: 'POST',
                data: {
                    type: 'eventList'
                },
                dataSrc: function (json) {
                    return json;
                },
            },
            columns: [
            {data: 'id'},    
            {
                data: null,
                render: function (data) {
                    return sDate(data['booking_date_time']);
                }
            },
            {
                data: null,
                render: function (data) {
                    return sDate(data['event_date_time']);
                }
            },
            { data: 'client_name' },
            { data: 'name' },
            { data: 'phone' },
            { data: 'email' },
            { data: 'package_name' },
            { data: 'event_name' },
            { data: 'venue' },
            { data: 'preference' },
            { data: 'song' },
            ],
            columnDefs: [
                { targets: 0, className: 'dt-center' },
                { targets: 1, className: 'dt-center' },
                { targets: 2, className: 'dt-center' },
                { targets: 5, className: 'dt-center' },
                { targets: 7, className: 'dt-center' },
                { targets: 8, className: 'dt-center' },
            ]
        });
    });
</script>