<?php
$_main_root = '../';
include($_main_root . "db/model.php");
include($_main_root . "config/config.php");
$db = new Model();

$mst = null;
$dtl = null;
$dtlGrp = [];
$others = null;

if (isset($_GET['quote_id'])) {
	$mstId = (int) $_GET['quote_id'];
	$mst = $db->GetQuotationMst(false, $mstId);
	$dtl = $db->GetQuotationDetails($mstId, false, true);
	$result = $db->conn->query("SELECT event_date AS d, COUNT(event_date) AS t FROM quote_details WHERE mst_id = $mstId GROUP BY event_date HAVING COUNT(event_date) > 1");
	if ($result && $result->num_rows > 0) {
		while ($row = $result->fetch_assoc()) {
			$dtlGrp[] = $row;
		}
	}

	$others = $db->GetQuotationOthers($mstId);
}
?>

<!DOCTYPE html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<link rel="stylesheet" href="<?php echo $_main_root; ?>style/download.css">

	<title><?= strtoupper($mst['client_name']) . "_Quotation"; ?></title>

	<style>
		
		@media print {
			body * {
				visibility: hidden;
				margin: 0;
				padding: 0;
			}

			@page {
				size: Legal portrait;
				margin: 10mm;
			}

			.print-area,
			.print-area * {
				visibility: visible;
			}
		}
	</style>
</head>

<body>

	<div class="print-area s-m-5">

		<div class="s-row">
			<div class="s-center">
				<img src="logo_black.png" height="40" />
			</div>
		</div>

		<div class="s-row">
			<span class="s-bold">Md Raihan Sayeem</span><br>
			<span class="s-ml-2" style="font-size: 12px;">Owner and Chief Photographer</span>
			<span class="s-ml-5 s-mt-2" style="font-size: 12px;">Contact: +8801673-157878<br>Location: House #478,
				Road-7, Block- H, Bashundhara R/A, Dhaka.<br>Email: snapmomentbd@gmail.com</span><br>
		</div>

		<!-- To -->
		<div class="s-row">
			<span>To,</span><br>
			<span class="s-ml-2 s-bold"><?= $mst['client_name'] ?></span>
		</div>

		<!-- Purpose -->
		<div class="s-row s-center s-bold">
			<span>Purpose: <?= $mst["purpose"] ?></span>
		</div>

		<!-- Details -->
		<div class="s-row">
			<span class="s-ml-2 s-bold">◾ Details :</span>
			<table class="s-table s-table s-table-sm s-table-border">
				<thead class="s-center s-bg-silver">
					<tr>
						<th>Date</th>
						<th>Location</th>
						<th>Package</th>
						<th>Event Time</th>
						<th>Reporting Time</th>
						<th>Photographer</th>
						<th>Cinemetographer</th>
					</tr>
				</thead>
				<tbody class="s-center-middle">
					<?php
					$preDate = "";
					foreach ($dtl as $row) {
						if ($preDate != $row["event_date"]) {
							$rowSpan = 1;
							foreach ($dtlGrp as $dg) {
								if ($row["event_date"] === $dg["d"]) {
									$rowSpan = (int) $dg["t"];
									break;
								}
							}
							?>
							<tr>
								<td class="" rowspan="<?= $rowSpan ?>"><?= sDate($row["event_date"]) ?>
								</td>
								<td><?= $row["location"] ?></td>
								<td><?= $row["package_name"] . (((int) $row["add_ons_id"] > 0) ? " + Add-Ons" : "") ?></td>
								<td><?= $row["event_time"] ?></td>
								<td><?= $row["report_time"] ?></td>
								<td><?= $row["photog"] ?></td>
								<td><?= $row["cinemetog"] ?></td>
							</tr>
						<?php
						} else { ?>
							<tr>
								<td><?= $row["location"] ?></td>
								<td><?= $row["package_name"] . (((int) $row["add_ons_id"] > 0) ? " + Add-Ons" : "") ?></td>
								<td><?= $row["event_time"] ?></td>
								<td><?= $row["report_time"] ?></td>
								<td><?= $row["photog"] ?></td>
								<td><?= $row["cinemetog"] ?></td>
							</tr>
						<?php
						}
						$preDate = $row["event_date"];
					}
					?>

				</tbody>
			</table>
		</div>

		<!-- Others -->
		<div class="s-row">
			<span class="s-ml-2 s-bold">◾ Others :</span>
			<table class="s-table s-table-sm s-table-border">
				<thead class="s-center s-bg-silver">
					<tr>
						<th>Edited Photos</th>
						<th>Printed Photos</th>
						<th>Photo Quantity</th>
						<th>Promo</th>
						<th>Video</th>
						<th>Album</th>
						<th>Photo Frame (10L)</th>
						<th>Drone</th>
					</tr>
				</thead>
				<tbody class="s-center-middle">
					<?php if (!empty($others)) { ?>
						<tr>
							<td><?= $others["edited_photo"] ?></td>
							<td><?= $others["printed_photo"] ?></td>
							<td><?= $others["photo_quality"] ?></td>
							<td><?= $others["promo"] . "<br>(2-3 Minutes)" ?></td>
							<td><?= $others["video"] . "<br>(15-25 Minutes)" ?></td>
							<td><?= $others["album"] ?></td>
							<td><?= $others["pf_10l"] ?></td>
							<td><?= $others["drone"] ?></td>
						</tr>
					<?php } else {
						echo '<tr><td colspan="8">Others is not defined in this Quotation.</td></tr>';
					} ?>
				</tbody>
			</table>
		</div>

		<!-- Cost Breakdown -->
		<div class="s-row">
			<span class="s-ml-2 s-bold">◾ Cost Breakdown :</span>
			<table class="s-table s-table-sm s-table-border">
				<thead class="s-center s-bg-silver">
					<tr>
						<th>Purpose</th>
						<th>Event Type</th>
						<th>Package Duration</th>
						<th>Price (BDT)</th>
					</tr>
				</thead>
				<tbody class="s-center-middle">
					<?php foreach ($dtl as $index => $row) {
						$purposeArr = PackageArr($row['purpose']);
						$purposeDtl = "Package: <b>" . htmlspecialchars($row["package_name"]) . "</b>";
						$purposeDtl = ((int) $row["package_id"] == 0) ? "" : $purposeDtl;
						$addOnsId = (int) ($row["add_ons_id"] ?? 0);

						if (!empty($purposeArr)) {
							foreach ($purposeArr as $value) {
								$purposeDtl .= (empty($purposeDtl) ? "" : "</br>") . "<b> • " . htmlspecialchars($value["title"]) . "</b>";
								$purposeDtl .= "<br>" . htmlspecialchars($value["details"]);
							}
						}
						$total = ((int) $row["package_id"] == 0) ? $row["out_amt"] : $row["package_amt"];
						?>
						<?php
						$bgColor = ($index % 2) == 0 ? '' : 's-bg-silver-200';
						echo '<tr class="'.$bgColor.'">';
						echo '<td class="">' . $purposeDtl . '</td>';
						echo '<td class="" rowspan="' . (($addOnsId > 0) ? 2 : 1) . '">' . $row["event_type"] . '</td>';
						echo '<td class="" rowspan="' . (($addOnsId > 0) ? 2 : 1) . '">' . nl2br($row["duration"]) . '</td>';
						echo '<td class="">' . sTakaFormat($total) . '</td>';
						echo '</tr>';

						if ($addOnsId > 0) {
							echo '<tr style="'.$bgColor.'">';
							echo '<td class="">Add-Ons: ' . $row["add_ons_name"] . '</td>';
							echo '<td class="">' . sTakaFormat($row["add_ons_amt"]) . '</td>';
							echo '</tr>';
						}
						?>
					<?php } ?>
					<tr class="s-bold">
						<td colspan="3" class="s-end" style="font-size: 16px;">Total : </td>
						<td style="font-size: 16px;"><?= sTakaFormat($mst["amount"], false, true, false) ?></td>
					</tr>
					<?php $discount = (int) ($mst["discount"] ?? 0);
					if ($discount > 0) { ?>
						<tr class="s-bold">
							<td colspan="3" class="s-end" style="font-size: 16px;">After Speacial Discount : </td>
							<td style="font-size: 16px;"><?= sTakaFormat($mst["total_amt"], false, true, false) ?></td>
						</tr>
					<?php } ?>
				</tbody>
			</table>
		</div>

		<!-- In Word -->
		<div class="s-row s-center">
			<span class="s-bold" colspan="4">In Word: <?= sNumberToWords($mst["total_amt"]) ?></span>
		</div>

		<!-- Note -->
		<div class="s-row">
			<span class="s-ml-2 s-bold">◾ Note:</span>
			<ul class="s-text-red" style="font-size:10px;">
				<li>If need any changes have to inform 2 weeks before the event.</li>
				<li>For more than 5 hours, the price will be increasing 2,000/- (BDT)for each person per hour. (6,000
					BDT for the Chief Photographer)</li>
				<li>Photos & videos will be saved up to 3 months after the event.</li>
				<li>You will get 50% refund if you cancel 30 days before the event.</li>
			</ul>
		</div>

		<!-- Delivery Timing -->
		<div class="s-row">
			<div class="s-ml-2">
				<span class="s-bold">◾ Delivery Timing:</span>
				<span style="font-size:12px;">Maximum 45 days after the event.</span>
			</div>
		</div>

		<!-- Confirmation -->
		<div class="s-row">
			<div class="s-ml-2">
				<span class="s-bold">◾ Confirmation:</span>
				<span style="font-size:12px;">Please complete the booking form and pay
					minimum<?= sTakaFormat(((int) $mst["total_amt"]) / 2, false, true) ?>/- of the total amount in
					advance.
					The remaining balance will be due at the end of the final event day.</span>
			</div>
		</div>

		<div class="s-row">
			<div class="s-center s-bold">
				Thank You<br>Snap Moment<br>
				<span style="font-size: 12px;">www.snapmomentbd.com</span>
			</div>
		</div>

	</div>

	<div class="s-center s-py-4">
		<input type="button" value="Print" class="s-btn s-btn-orange btn_print" onclick="print_summary()">
	</div>

	<script>
		window.onload = function () {
			window.print();
		};

		function print_summary() {
			window.print();
		}
	</script>
</body>
</html>