function ForPayment(id, onlyList = false) {
    dataTablePayList.clear();
    dataTablePayList.draw();
    $.ajax({
        type: "post",
        url: "emp_payment.php",
        data: {
            type: 'select',
            empId: id
        },
        success: function (response) {
            if (!onlyList) {
                $('#empName').text(response.emp.full_name);
                $('#empDue').text(response.emp.due_amt);
                $('#empPayment').val((response.emp.due_amt) < 0 ? 0 : response.emp.due_amt);
            }
            $('#empId').val(response.emp.id);
            response.payList.forEach(function (row) {
                dataTablePayList.row.add([
                    sDate(row.pay_date),
                    InvoicePrefix.EMP_PAY + row.invoice,
                    row.remarks,
                    row.amt,
                    ActionButtons(row)
                ]).draw();
            });
        }
    });
}


function ActionButtons(row) {
    var actionBtns = '<div class="text-center">';
    actionBtns += '<div class="btn-group">';

    if (Permission()) {
        actionBtns += '<button class="btn btn-sm action-btn" onclick="PaymentDelete(' + row.id + ')"><i class="bi bi-trash-fill"></i></button>';
    }

    actionBtns += '<a class="btn btn-sm action-btn" href="../print/emp_pay.php?id=' + row.id + '" target="_blank">';
    actionBtns += '<i class="bi bi-printer-fill"></i>';
    actionBtns += '</a>';

    actionBtns += '</div>';
    actionBtns += '</div>';

    return actionBtns;
}

function SubmitPayment() {
    var empId = $('#empId').val();
    var payDate = ($('#empPayDate').val());
    var remarks = $('#empRemarks').val();
    var payment = $('#empPayment').val();

    var printUrl = "../print/emp_pay.php?eid=" + empId;


    if (!empId || !payment) {
        swal('Please select an employee and enter a payment amount', {
            icon: "error",
        });
        return;
    }

    if (payment <= 0) {
        swal('Please enter a valid payment amount', {
            icon: "error",
        });
        return;
    }

    $.ajax({
        type: "POST",
        url: "emp_payment.php",
        data: {
            type: 'for_pay',
            empId: empId,
            payDate: payDate,
            remarks: remarks,
            payment: payment
        },
        success: function (response) {
            if (response.success) {
                swal("Payment successfully complete!", {
                    icon: "success",
                });

                $('#empId').val('');
                $('#empRemarks').val('');
                $('#empPayment').val('');
                $('#empName').text('-----');
                $('#empDue').text('-----');
                tablePayEmp.ajax.reload();
                ForPayment(empId, true);
                window.open(printUrl, "_blank");

            } else {
                swal('There was an error processing the payment', {
                    icon: "error",
                });
            }
        },
        error: function () {
            swal('An error occurred. Please try again', {
                icon: "error",
            });
        }
    });
}

function PaymentDelete(id) {
    var empId = $('#empId').val();

    swal({
        title: "Are you sure?",
        text: "Once deleted, you will not be able to recover this collection!",
        icon: "warning",
        buttons: true,
        dangerMode: true,
    }).then((willDelete) => {
        if (willDelete) {
            $.ajax({
                type: "post",
                url: "emp_payment.php",
                data: {
                    type: "pay_del",
                    payId: id,
                },
                success: function (response) {
                    if (response.success) {
                        swal("Payment successfully deleted!", {
                            icon: "success",
                        });
                        tablePayEmp.ajax.reload();
                        ForPayment(empId);

                    } else {
                        swal('There was an error processing the payment', {
                            icon: "error",
                        });
                    }
                },
                error: function () {
                    swal('An error occurred. Please try again', {
                        icon: "error",
                    });
                }
            });
        }
    });


}
