<?php
$_page_title = "Pending Event List";
$_main_root = '../';
require_once $_main_root . 'db/model.php';

$db = new Model();
if (isset($_POST['type'])) {
    if ($_POST['type'] == "eventList") {
        $list = $db->EventList(null, false, false, true);
        header('Content-Type: application/json');
        echo json_encode($list);
        exit();
    }
}
include($_main_root . 'content/common/header.php');
?>

<!-- ============= Pending event list start ================ -->

<!-- modal -->
<div id="paymentModalDiv"></div>

<div class="container container-fluid">
    <div class="my-4">
        <h2 style="color:var(--s-text-color);" class="text-center">PENDING EVENTS LIST</h2>
    </div>
    <div class="row justify-content-center my-4">
        <div class="table-responsive-lg">

            <table id="dataTable" class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">
                <thead style="color:var(--s-text-color);" class="mt-3">
                    <th style="width: 5px;">ID</th>
                    <th style="width: 84px;">Booking Date</th>
                    <th>Client Name</th>
                    <th>Phone</th>
                    <th style="width: 100px;">Event Type</th>
                    <th style="width: 150px;">Package Type</th>
                    <th style="width: 50px;">Package Amount</th>
                    <th style="width: 50px;">Due Amount</th>
                    <th style="width: 84px;">Event Date</th>
                    <th style="width: 60px;">Event Time</th>
                    <th style="width: 50px;">Action</th>
                </thead>
                <tbody>
                </tbody>
            </table>

        </div>
    </div>
</div>

<!-- ============= Pending event list end ================ -->
<?php $s_scripts = ['payment']; ?>
<?php include($_main_root . 'content/common/footer.php'); ?>
<script>
    $(document).ready(function () {
        table = $('#dataTable').DataTable({
            order: [],
            ajax: {
                url: 'event_list_due.php',
                type: 'POST',
                data: {
                    type: 'eventList'
                },
                dataSrc: function (json) {
                    return json;
                },
            },
            columns: [
            {data: 'id'},    
            {
                data: null,
                render: function (data) {
                    return sDate(data['booking_date_time']);
                }
            },
            {
                data: 'client_name'
            },
            {
                data: 'phone'
            },
            {
                data: 'event_name'
            },
            {
                data: 'package_name',
            },
            {
                data: 'total_amt'
            },
            {
                data: 'due_amount'
            },
            {
                data: null,
                render: function (data) {
                    return sDate(data['event_date_time']);
                }
            },
            {
                data: null,
                render: function (data) {
                    return sTime(data['event_date_time']);
                }
            },
            {
                data: null,
                render: function (data, type, row) {
                    var btn = '<div class="btn-group">';
                    btn += '<button type="button" name="payment" class="btn btn-sm action-btn" onclick="PaymentForm(' + row.id + ')">Payment</button>';
                    btn += '</div>';
                    return btn;
                }
            }
            ],
            columnDefs: [
                { targets: 1, className: 'dt-center' },
                { targets: 4, className: 'dt-center' },
                { targets: 6, className: 'dt-right' },
                { targets: 7, className: 'dt-right' },
                { targets: 8, className: 'dt-center' },
                { targets: 9, className: 'dt-center' },
                { targets: 10, className: 'dt-center' }
            ]
        });
    });
</script>