<?php
$_page_title = "Login";
$_main_root = '';
$_login_page = true;
$_public_form = false;

if (!class_exists('User')) {
  include($_main_root . 'config/enum.php');
}

if (User::Login()) {
  header("Location: content/dashboard.php");
  exit();
}

include($_main_root . "content/shared/header.php");

?>

<style>
  @import url('https://fonts.googleapis.com/css2?family=Noto+Sans:wght@700&family=Poppins:wght@400;500;600&display=swap');

  * {
    margin: 0;
    padding: 0;
    font-family: "Poppins", sans-serif;
  }

  .gradient-custom {
    background-image: url("img/login_background.png");
    /* min-height: 380px; */
    background-position: center;
    background-repeat: no-repeat;
    background-size: cover;
    position: relative;
  }

  .bg-dark {
    --bs-bg-opacity: 0.7 !important;
  }

  .card {
    border-radius: 1rem;
    border: 1px solid var(--s-text-color);
    box-shadow: 0 0 20px 0px var(--s-text-color);
  }

  form .form-outline {
    position: relative;
    border-bottom: 2px solid #adadad;
    margin: 30px 0;

  }

  .form-outline input {
    width: 100%;
    padding: 0 5px;
    height: 40px;
    color: var(--bs-heading-color, inherit);
    font-size: 16px;
    border: none;
    background: none;
    outline: none;
    caret-color: red;
  }

  .form-outline label {
    position: absolute;
    top: 40%;
    left: 5px;
    color: var(--bs-heading-color, inherit);
    transform: translateY(-50%);
    font-size: 18px;
    pointer-events: none;
    transition: .5s;
  }

  .form-outline span::before {
    content: '';
    position: absolute;
    top: 40px;
    left: 0;
    width: 0%;
    height: 2px;
    background: var(--s-text-color);
    transition: .5s;
  }

  .form-outline input:focus~label,
  .form-outline input:valid~label {
    top: -5px;
    color: var(--s-text-color);
  }

  .form-outline input:focus~span::before,
  .form-outline input:valid~span::before {
    width: 100%;
  }

  input:-webkit-autofill,
  input:-webkit-autofill:hover,
  input:-webkit-autofill:focus,
  input:-webkit-autofill:active {
    transition: background-color 9999s ease-in-out 0s;
    -webkit-text-fill-color: #ffffff;
  }

  input[readonly] {
    background-color: transparent !important;
  }

  .navbar {
    --bs-navbar-padding-y: 0 !important;
  }
</style>

<section class="vh-100 gradient-custom">
  <div class="container py-5 h-100">
    <div class="w-100 text-center">
      <img style="width:450px;" src="img/logo.png" alt="SnapMoment_Logo">
    </div>
    <div style="margin-top: -100px;" class="row d-flex justify-content-center align-items-center h-100">
      <div class="col-12 col-sm-10 col-md-8 col-lg-4">
        <div class="card bg-dark text-white">
          <div class="card-body p-sm-3 p-md-5 text-center">
            <div class="">
              <form action="db/do_login.php" method="post">
                <h2 class="fw-bold mb-4 text-uppercase">Sign In</h2>
                <hr>
                <div class="form-outline form-white mb-4 mt-5">
                  <input type="text" id="username" name="username" readonly onfocus="focusFunction()" required />
                  <span></span>
                  <label for="username">User</label>
                </div>

                <div class="form-outline form-white mb-4">
                  <input type="password" id="password" name="password" readonly onfocus="focusFunction()" required />
                  <span></span>
                  <label for="password">Password</label>
                </div>

                <button type="submit" name="submit" class="btn btn-outline-light btn-lg px-4">Continue</button>
              </form>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<?php include($_main_root . "content/shared/footer.php"); ?>

<script>
  function focusFunction() {
    document.getElementById("username").removeAttribute('readonly');
    document.getElementById("password").removeAttribute('readonly');
  }
</script>