<?php
$_main_root = '../';
include($_main_root . "db/model.php");
include($_main_root . "config/config.php");
$db = new Model();

$billNum = null;
$billMst = null;
$billDtl = null;
$payment = null;
$dueAmount = 0;

if (isset($_GET['billNum'])) {
	$billNum = $_GET['billNum'];
	$billMst = $db->GetBillMst(false, $billNum);
	$billDtl = $db->GetBillDtlByBillNumber($billNum);
	$payment = $db->GetBillPayByBillNum($billNum, false, false, true);

	$paymentValue = is_numeric($payment) ? (int) $payment : 0;
	$totalBillAmount = is_numeric($billMst["ttl_bill_amt"]) ? (int) $billMst["ttl_bill_amt"] : 0;
	$dueAmount = $totalBillAmount - $paymentValue;
}
?>

<!DOCTYPE html>
<html>

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<link rel="stylesheet" href="<?php echo $_main_root; ?>vendor/bootstrap-5.3.0/css/bootstrap.min.css">

	<title><?= strtoupper($billMst['name']) . "_Due_Bill_" . $billNum; ?></title>

	<style>
		body {
			font-family: 'Times New Roman', Times, serif;
			margin: 0;
			padding: 0;
			max-width: 960px;
			margin: auto;
		}

		@media print {
			body * {
				visibility: hidden;
				font-size: 14px;
				line-height: 18px;
				margin: 0;
				padding: 0;
			}

			@page {
				size: A4 portrait;
				margin: 10mm;
			}

			.print-area,
			.print-area * {
				visibility: visible;
			}

			#report-header {
				position: fixed;
				left: 0;
				top: 0;
				right: 0;
			}

			#report-body {
				margin: 110px 5px 0 5px;
				position: relative;
				z-index: 999;
			}

			#report-footer {
				position: fixed;
				left: 0;
				right: 0;
				bottom: 0;
			}
		}
	</style>
</head>

<body>

	<div class="print-area">

		<!-- Report Header -->
		<div id="report-header">
			<table class="w-100">
				<tr>
					<td style="text-align: left;"> <img src="snapmoment_logo.png" width="260" />
					</td>
					<td class="text-end">
						<p class="mb-1">CLIENT BILL</p>
						<p class="fw-bold mb-1"><?= InvoicePrefix::BILL_NUMBER . $billNum; ?></p>
						Contact: +8801673-157878 <br>
						Location: House #478, Road-7, <br>
						Block- H, Bashundhara R/A, Dhaka.
					</td>
				</tr>
			</table>
		</div>

		<!-- Report Body -->
		<div id="report-body">
			<table class="w-100 my-2">
				<tr>
					<td>
						To,<br />
						<h5>&nbsp;&nbsp;<strong><?= strtoupper($billMst['name']); ?></strong></h5>
					</td>
					<td class="text-end">
						Print Date: <b><?= sDate(date("Y-m-d H:i:s"), true) ?></b>
					</td>
				</tr>
			</table>

			<table class="table table-sm table-bordered border-black mb-0">
				<thead class="table-dark text-light">
					<tr class="text-center">
						<th style="width:140px">Event ID / Date</th>
						<th>Description</th>
						<th style="width:180px">Duration</th>
						<th style="width:100px">Amount</th>
					</tr>
				</thead>
				<tbody>
					<?php
					if (!empty($billDtl)) { // Added a check if $billDtl is not empty
						foreach ($billDtl as $row) {
							$packageName = "Package: <b>" . htmlspecialchars($row["package_name"]) . "</b>"; // htmlspecialchars for safety
							$addTimeArr = AdditionalTimeArr($row["add_time"]);
							$outdoorArr = AdditionalTimeArr($row["outdoor"]);
							$packageArr = PackageArr($row["package_dtl"]);
							$addOnsArr = AddOnsArr($row["addons"]);
							$packageDtl = '';

							if (!empty($packageArr)) {
								foreach ($packageArr as $value) {
									$packageDtl .= "<br><b> • " . htmlspecialchars($value["title"]) . "</b>";
									$packageDtl .= "<br>" . htmlspecialchars($value["details"]);
								}
							}

							$rowSpan = 1;
							if (!empty($outdoorArr)) {
								$rowSpan++;
							}

							if (!empty($addTimeArr)) {
								$rowSpan++;
							}

							$addOnsDetails = '';
							$addOnsAmount = 0;
							$rowSpanAddOns = '';
							if (!empty($addOnsArr)) {
								// Adjust rowspan for the main row if add-ons are present
								$rowSpan++;
								$rowSpanAddOns = 'rowspan="2"';
								foreach ($addOnsArr as $value) {
									$addOnsDetails .= (empty($addOnsDetails) ? "" : "<br>") . "• " . htmlspecialchars($value["name"]) . " (" . htmlspecialchars($value["amount"]) . ")";
									$addOnsAmount += (int) $value["amount"];
								}
							}

							$description = $packageName . $packageDtl;
							// Package
							echo '<tr>';
							echo '<td class="text-center" rowspan="' . $rowSpan . '"> (' . htmlspecialchars($row["event_id"]) . ')<br>' . sDate($row["event_date_time"]) . '</td>';
							echo '<td class="text-center">' . $description . '</td>';
							echo '<td class="text-center" ' . $rowSpanAddOns . '>' . htmlspecialchars($row["duration"]) . '</td>';
							echo '<td class="text-end">' . sTakaFormat($row["amount"]) . '</td>';
							echo '</tr>';

							// Add-ons
							if (!empty($addOnsArr)) {
								echo '<tr>';
								echo '<td class="text-center">Add-Ons: <b>' . $addOnsDetails . '</b></td>';
								echo '<td class="text-end">' . sTakaFormat($addOnsAmount) . '</td>';
								echo '</tr>';
							}

							// Outdoor
							if (!empty($outdoorArr)) {
								echo '<tr>';
								echo '<td class="text-center"><b>Outdoor</b></td>';
								echo '<td class="text-center">' . htmlspecialchars($outdoorArr["hours"]) . '</td>';
								echo '<td class="text-end">' . sTakaFormat($outdoorArr["amount"]) . '</td>';
								echo '</tr>';
							}

							// Additional Time
							if (!empty($addTimeArr)) {
								echo '<tr>';
								echo '<td class="text-center"><b>Additional Time</b></td>';
								echo '<td class="text-center">' . htmlspecialchars($addTimeArr["hours"]) . '</td>';
								echo '<td class="text-end">' . sTakaFormat($addTimeArr["amount"]) . '</td>';
								echo '</tr>';
							}
						}
					} else {
						echo '<tr><td colspan="4" class="text-center">No bill details found.</td></tr>';
					}

					// Summary rows
					$displayBillAmount = isset($billMst["bill_amt"]) ? $billMst["bill_amt"] : 0;
					$displayDiscount = isset($billMst["discount"]) ? $billMst["discount"] : 0;

					echo '<tr class="border-0">';
					echo '<td class="border-0 ps-2 pt-2 pe-2" colspan="2" rowspan="2">In word: <b>' . sNumberToWords($dueAmount) . '</b></td>';
					echo '<td class="border-0 border-black border-bottom text-end"><b>Total :</b></td>';
					echo '<td class="border-black border-bottom text-end"><b>' . sTakaFormat($displayBillAmount) . '</b></td>';
					echo '</tr>';

					echo '<tr class="border-0">';
					echo '<td class="border-0 border-black border-bottom text-end">Payment :</td>';
					echo '<td class="border-black border-bottom text-end">' . sTakaFormat($payment) . '</td>';
					echo '</tr>';

					if ((int) $displayDiscount > 0) {
						echo '<tr class="border-0">';
						echo '<td class="border-0 text-end" colspan="2"></td>';
						echo '<td class="border-0 border-black border-bottom text-end">Special Discount :</td>';
						echo '<td class="border-black border-bottom text-end">' . sTakaFormat($displayDiscount) . '</td>';
						echo '</tr>';
					}

					echo '<tr class="border-0">';
					echo '<td class="border-0 text-end" colspan="3"><b>Balance Due :</b></td>';
					echo '<td class="border-black border-bottom text-end table-danger"><b>' . sCurrencySymbol() . sTakaFormat($dueAmount) . '</b></td>';
					echo '</tr>';
					?>
				</tbody>
			</table>

			<table class="w-100">
				<tr class="">
					<td>
						<img class="ms-4" src="raihan_signature.jpg" style="height: 110px;" />
					</td>
					<td class="text-center align-bottom">

					</td>
				</tr>
			</table>
		</div>

		<!-- Report Footer -->
		<div id="report-footer">
			<table class="w-100">
				<tr>
					<td class="text-center">
						<img src="payment_method.jpg" height="130" />
					</td>
				</tr>
			</table>
		</div>

	</div>

	<div class="text-center" style="padding:20px;">
		<input type="button" value="Print" class="btn btn-success btn_print" onclick="print_summary()">
	</div>

	<script>
		window.onload = function () {
			window.print();
		};

		function print_summary() {
			window.print();
		}
	</script>

</body>

</html>