<?php

$_page_title = "Payment";
$_main_root = '../';

require_once $_main_root . 'db/model.php';
$obj = new Model();

if (isset($_POST['type'])) {
    if ($_POST['type'] == "empList") {
        $empList = $obj->EmployeeList();
        header('Content-Type: application/json');
        echo json_encode($empList);
        exit;
    }

    if ($_POST["type"] === "select") {
        if (isset($_POST["empId"])) {
            $id = $_POST['empId'];
    
            $emp = $obj->GetEmpById($id);
            $payList=$obj->GetEmpPayByEmpId($id);
    
            header('Content-Type: application/json');
            echo json_encode(['emp'=>$emp, 'payList'=>$payList]);
            exit;
        }
    }

    if ($_POST["type"] === "for_pay") {
        if (isset($_POST["empId"]) && isset($_POST['payment'])) {
    
            $success = false;
            try {
                $obj->EmployeePayment($_POST);
                $success = true;
            } catch (\Throwable $th) {
                $success = false;
            }
    
            header('Content-Type: application/json');
    
            if ($success) {
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false]);
            }
            exit;
        }
    }

    if ($_POST["type"] === "pay_del") {
        if (isset($_POST["payId"])) {
            $pay_id=$_POST["payId"];
            
            header('Content-Type: application/json');
    
            if ($obj->EmployeePaymentDelete($pay_id)==1) {
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false]);
            }
            exit;
        }
    }
}

include($_main_root . 'content/common/header.php');
if (!Permission(2)) {
    return;
}

?>

<!-- modal -->
<div id="modalDiv"></div>

<div class="container container-fluid">

    <div class="my-4 d-flex justify-content-between align-items-center">
        <h2 style="color:var(--s-text-color);">PAYMENT</h2>
        <div>
            <a href="employee.php" class="btn btn-sm btn-outline-info">
                <i class="bi bi-list-task me-e"></i> EMPLOYEE LIST</a>
        </div>
    </div>

    <div class="row my-4">
        <div class="card bg-dark" style="border-color: var(--s-text-color);">
            <div class="card-body text-white">
                <div class="row mb-3">
                    <div class="col-12 col-md-8 mb-2">
                        <label for="employee" class="form-label fw-bold" style="color:var(--s-text-color-2)">Employee/Photographer</label>
                        <hr class="mt-0">
                        <div class="table-responsive-lg">
                            <table id="dataTable" class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">
                                <thead style="color:var(--s-text-color);" class="mt-3">
                                    <th>Employee Name</th>
                                    <th>Designation</th>
                                    <th style="width: 50px;">Payable</th>
                                    <th style="width: 80px;">Action</th>
                                </thead>
                                <tbody>
                                    
                                </tbody>

                            </table>
                        </div>
                    </div>

                    <div class="col-12 col-md-4">
                        <label for="" class="form-label fw-bold" style="color:var(--s-text-color-2)">Payment Details</label>
                        <hr class="mt-0">
                        <div id="custom-form-light" class="rounded">
                            <div class="p-3">
                                <input type="hidden" name="empId" id="empId" value="">
                                <table class="w-100">
                                    <tr>
                                        <td><label for="empPayDate" class="">Payment Date</label></td>
                                        <td><input type="text" name="empPayDate" id="empPayDate" class="form-control"></td>
                                    </tr>
                                    <tr>
                                        <td><label for="empName" class="">Name</label></td>
                                        <td><label for="empName" id="empName" class="" style="color:var(--s-text-color-1)">-----</label></td>
                                    </tr>
                                    <tr>
                                        <td><label for="empDue" class="">Total Due</label></td>
                                        <td><label for="empDue" id="empDue" class="" style="color:var(--s-text-color-1)">-----</label></td>
                                    </tr>
                                    <tr>
                                        <td><label for="empRemarks" class="">Remarks</label></td>
                                        <td><input type="text" name="empRemarks" id="empRemarks" class="form-control"></td>
                                    </tr>
                                    <tr>
                                        <td><label for="empPayment" class="">Payment</label></td>
                                        <td><input type="number" name="empPayment" id="empPayment" class="form-control"></td>
                                    </tr>
                                </table>
                                <div class="mt-3 text-center">
                                    <button class="btn btn-sm action-btn-1 px-4" onclick="SubmitPayment()">Payment</button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row mb-3 mt-5">
                    <div class="col-12 mb-2">
                        <label for="employee" class="form-label fw-bold" style="color:var(--s-text-color-2)">Payment Details</label>
                        <hr class="mt-0">
                        <div class="table-responsive-lg">
                            <table id="dataTablePayList" class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">
                                <thead style="color:var(--s-text-color);" class="mt-3">
                                    <th style="width: 100px;">Date</th>
                                    <th style="width: 150px;">Invoice</th>
                                    <th>Details</th>
                                    <th style="width: 50px;">Amount</th>
                                    <th style="width: 80px;">Action</th>
                                </thead>
                                <tbody>

                                </tbody>

                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $s_scripts = ['emp_payment']; ?>
<?php include($_main_root . 'content/common/footer.php'); ?>

<script>
    $(document).ready(function() {
        tablePayEmp = $('#dataTable').DataTable({
            ordering: false,
            iDisplayLength: 10,
            ajax: {
                url: 'emp_payment.php',
                type: 'POST',
                data: {
                    type: 'empList'
                },
                dataSrc: function(json) {
                    return json;
                },
            },
            columns: [
                {data: 'full_name'},
                {data: 'designation'},
                {
                    data: null,
                    render: function(data, type, row) {
                        var btn = '<div class="text-end">';
                        btn += '<span>'+row.due_amt+'</span>';
                        btn += '</div>';
                        return btn;
                    }
                },
                {
                    data: null,
                    render: function(data, type, row) {
                        var btn = '<div class="text-center"><div class="btn-group">';
                        btn += '<button type="button" class="btn btn-sm action-btn" onclick="ForPayment(' + row.id + ')">Select <i class="bi bi-arrow-right"></i></button>';
                        btn += '</div></div>';
                        return btn;
                    }
                }
            ]
        });

        dataTablePayList = $('#dataTablePayList').DataTable({
            ordering: false
        });
    });
</script>