<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

$_page_title = "Booking Form";
$_main_root = '';
require_once $_main_root . 'db/model.php';
$db = new Model();

$countryList = $db->GetCountryList();
$package_list = null;
$event = null;
$eventAddOnsList = null;

if (User::Login()) {
    $_login_page = false;
    $_main_root = '';

    if (isset($_GET['token'])) {
        $id = $_GET['token'];
        $event = $db->GetEventById($id);
        $eventAddOnsList = $db->GetEventAddOnsByEventId($id);
    }
} else {
    $_login_page = true;
    $_public_form = true;
}

if (isset($_POST['type'])) {
    header('Content-Type: application/json');

    if ($_POST['type'] == 'packageList') {
        $package_list = $db->GetPackage();
        echo json_encode(['items' => $package_list]);
    } elseif ($_POST['type'] == 'addOnsList') {
        $addons_list = $db->AddOnsList(true);
        echo json_encode(['addons' => $addons_list]);
    } elseif ($_POST['type'] == 'submit_frm') {
        $result = $db->BookingInfo($_POST['frmData']);
        if ((int)$result > 0) {
            echo json_encode(['success' => true, 'message' => 'Booking has been successfully submitted!', 'eventId' => $result]);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to process the booking. Please try again later.']);
        }
    } elseif ($_POST['type'] == 'update_frm') {
        $result = $db->BookingInfo($_POST['frmData']);
        if ($result) {
            echo json_encode(['success' => true, 'message' => 'update']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to process the booking. Please try again later.']);
        }
    } elseif ($_POST['type'] == 'deao') {
        $result = $db->DeleteEventAddOns($_POST['id']);
        if ($result) {
            echo json_encode(['success' => true, 'message' => 'd']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Failed to process. Please try again later.']);
        }
    }
    exit;
}


$event_type_list = $db->EventTypeList(true);

include($_main_root . "content/common/header.php");
?>
<style>
    .btn-no-border:active {
        border-color: transparent !important;
        box-shadow: none;
    }
</style>

<div id="modalDiv"></div>

<img id="booking-cover-img" src="img/booking_cover.jpg" alt="Booking Cover" width="100%">

<div class="container container-fluid d-flex justify-content-center form-container">
    <div id="custom-form-dark" class="col-12 col-md-8 p-4 m-3"
        style="border-radius: 10px; box-shadow: 0 0 20px 15px black;">
        <form action="" method="post" class="was-validated">
            <div class="row mb-3">
                <div class="col-12">
                    <label for="" class="form-label">Client's Name</label>
                    <input type="text" name="client_name" id="client_name" class="form-control"
                        value="<?php echo ($event) ? $event['client_name'] : '' ?>" required>
                </div>
            </div>
            <div class="row">
                <div class="col-12 col-md-6 mb-3">
                    <label for="" class="form-label">Contact No.</label>
                    <div class="input-group">
                        <!-- <select id="countryList" name="countryList" class="form-control form-select" required>
                            <?php
                            foreach ($countryList as $country) {
                                echo '<option value="' . $country['dial_code'] . '" ' . (($country['name'] == $traficCountry) ? "selected" : "") . '>' . $country['name'] . ' (' . $country['dial_code'] . ')' . '</option>';
                            }
                            ?>
                        </select> -->
                        <input type="text" name="contact_no" id="contact_no" class="form-control"
                            value="<?php echo ($event) ? $event['phone'] : '' ?>" placeholder="01xxx-xxxxxx" required>
                    </div>
                </div>
                <div class="col-12 col-md-6 mb-3">
                    <label for="" class="form-label">Email</label>
                    <input type="email" name="email" id="email" class="form-control"
                        value="<?php echo ($event) ? $event['email'] : '' ?>" placeholder="example@mail.com" required>
                </div>
            </div>
            <div class="row mb-3">
                <div class="col-12">
                    <label for="" class="form-label">Event's Type</label>
                    <select id="eventType" name="eventType" class="form-control" required>
                        <option value="">Select Event Type</option>
                        <?php
                        foreach ($event_type_list as $event_type) {
                            echo '<option value="' . $event_type['id'] . '" ' . (($event && $event['event_type_id'] == $event_type['id']) ? 'selected' : '') . '>' . $event_type['name'] . '</option>';
                        }
                        ?>
                    </select>
                </div>
            </div>
            <div class="row s-cond-field groom_name">
                <div class="col-12 col-md-6 mb-3">
                    <label for="" class="form-label">Groom's Name</label>
                    <input type="text" name="groom_name" id="groom_name" class="form-control"
                        value="<?php echo ($event) ? $event['groom'] : '' ?>">
                </div>
                <div class="col-12 col-md-6 mb-3">
                    <label for="" class="form-label">Bride's Name</label>
                    <input type="text" name="bride_name" id="bride_name" class="form-control"
                        value="<?php echo ($event) ? $event['bride'] : '' ?>">
                </div>
            </div>
            <div class="row mb-3 s-cond-field birthday_person">
                <div class="col-12">
                    <label for="" class="form-label">Birthday Person's Name</label>
                    <input type="text" name="birthday_person" id="birthday_person" class="form-control"
                        value="<?php echo ($event) ? $event['birthday_person'] : '' ?>">
                </div>
            </div>
            <div class="row mb-3 s-cond-field organization_name">
                <div class="col-12">
                    <label for="" class="form-label">Organization's Name</label>
                    <input type="text" name="organization_name" id="organization_name" class="form-control"
                        value="<?php echo ($event) ? $event['org_name'] : '' ?>">
                </div>
            </div>
            <div class="row mb-3 s-cond-field packages_Field">
                <div class="col-12">
                    <input type="hidden" id="selected_package_id"
                        value="<?php echo ($event) ? $event['package_id'] : '' ?>">
                    <label for="" class="form-label">Packages</label>
                    <select id="packageList" name="packageList" class="form-control" required>
                    </select>
                </div>
            </div>
            <div class="row mb-3 s-cond-field addons_Field">
                <?php if ($event) { ?>
                    <div class="col-12">
                        <label for="" class="form-label">Selected Add Ons</label>
                        <div class="" id="">
                            <table class="table table-sm table-dark table-hover border border-secondary">
                             <tbody>
                                <?php if($eventAddOnsList){ foreach ($eventAddOnsList as $eventAddOns) { ?>
                                    <tr>
                                        <td><?php echo $eventAddOns['addons_name'];?></td>
                                        <td><?php echo $eventAddOns['amount'];?></td>
                                        <td style="width:50px;">
                                            <button class="btn btn-sm text-danger fw-bold" onclick="DeleteEventAddons(<?php echo $eventAddOns['id'];?>)">Delete</button>
                                        </td>
                                    </tr>
                                <?php }}?>
                                <tr class="text-center">
                                    <td colspan="3"><button class="btn btn-sm text-warning fw-bold px-5" onclick="AddEventAddOns(<?php echo $event['id'];?>)">ADD ADD-ONS</button></td>
                                </tr>
                            </tbody>
                            </table>
                            <div >
                                
                            </div>
                        </div>
                    </div>
                <?php } else { ?>
                    <div class="col-12">
                        <label for="" class="form-label">Add Ons</label>
                        <div class="d-grid gap-1" id="addons-container"></div>
                    </div>
                    <p class="col-12 d-flex justify-content-end mt-1" style="margin-bottom: 0 !important;">
                        <a type="button"
                            class="fw-bold link-secondary link-underline-opacity-0 link-underline-opacity-100-hover"
                            id="anotherAddOns"><i class="bi bi-plus-lg"></i> ADD ANOTHER ADD-ONS</a>
                    </p>
                <?php }?>
            </div>
            <div class="row mb-3 s-cond-field amount">
                <div class="col-12">
                    <label for="" class="form-label">Amount</label>
                    <input type="number" name="amount" id="amount" class="form-control"
                        value="<?php echo ($event) ? $event['amount'] : '' ?>" placeholder="Enter Your Package Amount">
                </div>
            </div>
            <div class="row s-cond-field location_event_date_time">
                <div class="col-12 col-md-6 mb-3">
                    <label for="" class="form-label">Venue Location</label>
                    <input type="text" name="location" id="location" class="form-control"
                        value="<?php echo ($event) ? $event['venue'] : '' ?>">
                </div>
                <div class="col-12 col-md-6 mb-3">
                    <label for="" class="form-label">Date / Time</label>
                    <input type="text" name="event_date_time" id="event_date_time" class="form-control" autocomplete="off"
                        value="<?php echo ($event) ? sDate($event['event_date_time'], false, true) : '' ?>">
                </div>
            </div>
            <div class="row mb-3 s-cond-field song_preference">
                <div class="col-12">
                    <label for="" class="form-label">Song Preference</label>
                    <input type="text" name="song_preference" id="song_preference" class="form-control"
                        value="<?php echo ($event) ? $event['song'] : '' ?>">
                    <div class="s-alert-warning mt-1">
                        If you want to suggest any song in your <strong>CINEMATOGRAPHY</strong>, you can give the link
                        or name here.
                    </div>
                </div>
            </div>
            <div class="row mb-3 s-cond-field your_preference">
                <?php $yourPreference = ($event) ? explode(',', $event['preference']):null;?>
                <label for="" class="form-label">Your Preference</label>
                <div class="col-6 col-md-6">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Couple Photos" id="couplePhotos"
                            name="couplePhotos" <?php echo (($event) && in_array('Couple Photos', $yourPreference)) ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="couplePhotos">
                            Couple Photos
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Candid Photos" id="candidPhotos"
                            name="candidPhotos" <?php echo (($event) && in_array('Candid Photos', $yourPreference)) ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="candidPhotos">
                            Candid Photos
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Outdoor Photos" id="outdoorPhotos"
                            name="outdoorPhotos" <?php echo (($event) && in_array('Outdoor Photos', $yourPreference)) ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="outdoorPhotos">
                            Outdoor Photos
                        </label>
                    </div>
                </div>
                <div class="col-6 col-md-6">
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Family Photos" id="familyPhotos"
                            name="familyPhotos" <?php echo (($event) && in_array('Family Photos', $yourPreference)) ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="familyPhotos">
                            Family Photos
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Guest Photos" id="guestPhotos"
                            name="guestPhotos" <?php echo (($event) && in_array('Guest Photos', $yourPreference)) ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="guestPhotos">
                            Guest Photos
                        </label>
                    </div>
                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" value="Others" id="others" 
                            name="others" <?php echo (($event) && in_array('Others', $yourPreference)) ? 'checked' : ''; ?>>
                        <label class="form-check-label" for="others">
                            Others
                        </label>
                    </div>
                </div>
                <div class="col-12">
                    <div class="s-alert-warning mt-1">
                        <div>Note:</div>
                        <div class="ps-2"> ❐ For <strong>Standard</strong> and <strong>Only Photography</strong>
                            packages, we accept only two preferences from booking form.</div>
                        <div class="ps-2"> ❐ Your <strong>booking</strong> will be confirmed after paying
                            <strong>50%</strong> within <strong>72 hours</strong>.
                        </div>
                    </div>
                </div>
            </div>
            <?php if($event) {?>
            <div class="row mb-3 justify-content-center">
                <div class="col-12">
                    <label for="eventStatus" class="form-label">Event Status</label>
                    <select id="eventStatus" name="eventStatus" class="form-control">
                        <?php
                        foreach (EventStatus::StatusLabel() as $key => $value) {
                            echo '<option value="' . $key . '" '. (($event["status"] == $key)?"selected":"") .'>' . $value . '</option>';
                        }
                        ?>
                    </select>
                </div>
            </div>
            <?php }?>
            <div class="d-flex justify-content-center">
                <button type="button" class="btn px-4 mt-3 action-btn-2"
                    onclick="bookEvent(<?php echo ($event) ? $event['id'] : ''; ?>)"><?php echo ($event) ? 'Update Booking' : 'Book Now'; ?></button>
            </div>
        </form>
    </div>

</div>

<?php $s_scripts = ['book_us']; ?>
<?php include($_main_root . "content/common/footer.php"); ?>