<?php
session_start();

include('../db/model.php');
include('../config/config.php');
$db = new Model();
$tableHeight = '';
$forPayment = $_POST['type'] == 'details' ? false : true;

$forEdit = $_POST['type'] == 'editForm' ? true : false;

if ($_POST['type'] == 'form' || $_POST['type'] == 'details') {
    $eventId = $_POST['id'];
    $event = $db->GetEventById($eventId);
    $paymentDetails = $db->EventPayListByEventId($eventId);
} else if ($_POST['type'] == 'editForm') {
    $eventId = $_POST['eventId'];
    $event = $db->GetEventById($eventId);
    $payment = $db->GetEventPaymentById($_POST['payId']);
} else if ($_POST['type'] == 'payment') {
    $pay_amt = $_POST['payment_amt'];
    if ($pay_amt > 0) {
        $isPay = $db->EventPayment($_POST);
        return;
    }
    return;
} else if ($_POST['type'] == 'discount') {
    $disc_amt = $_POST['discount_amt'];
    if ($disc_amt >= 0) {
        return $db->Discount($_POST);
    }
    return;
} else if ($_POST['type'] == 'update') {
    $isUpdate = $db->UpdateEventPayment($_POST);
    return;
} else if ($_POST['type'] == 'delete') {
    $isUpdate = $db->DeleteEventPayment($_POST['payId']);
    return;
}

?>
<div class="modal fade" id="paymentModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
    aria-labelledby="paymentModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header text-center">
                <h1 class="modal-title fs-5 w-100" id="paymentModalLabel">
                    <?php if ($forPayment) {
                        echo 'Payment';
                    } else {
                        echo 'Payment Details';
                    } ?>
                </h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            
            <div id="custom-form-light">
                <div class="modal-body">
                    <input type="hidden" name="mId" id="mId" value="<?php echo $event['id']; ?>">
                    <?php if ($forPayment) {
                        $tableHeight = 'height:150px;' ?>

                        <div class="mb-3">
                            <label for="mClientName">Client Name</label>
                            <input type="text" name="mClientName" id="mClientName"
                                value="<?php echo $event['client_name']; ?>" readonly class="form-control">
                        </div>

                        <div class="input-group">
                            <div class="col-12 col-sm-12 col-md-6 mb-3 pe-md-2">
                                <label for="mEventType">Event Type</label>
                                <input type="text" name="mEventType" id="mEventType"
                                    value="<?php echo $event['event_name']; ?>" readonly class="form-control">
                            </div>
                            <div class="col-12 col-sm-12 col-md-6 mb-3 ms-auto me-0 ps-md-2">
                                <label for="mPackageType">Package Type</label>
                                <input type="text" name="mPackageType" id="mPackageType"
                                    value="<?php echo $event['package_name']; ?>" readonly class="form-control">
                            </div>
                        </div>

                        <div class="input-group">
                            <div class="col-12 col-sm-12 col-md-4 mb-3 pe-md-2">
                                <label for="mPackageAmount">Package Amount</label>
                                <input type="number" name="mPackageAmount" id="mPackageAmount"
                                    value="<?php echo $event['total_amt']; ?>" readonly class="form-control">
                            </div>
                            <div class="col-12 col-sm-12 col-md-4 mb-3 ms-auto me-0 ps-md-2 pe-md-2">
                                <label for="mDueAmount">Due Amount</label>
                                <input type="number" name="mDueAmount" id="mDueAmount"
                                    value="<?php echo $event['due_amount']; ?>" readonly class="form-control text-danger">
                            </div>
                            <div class="col-12 col-sm-12 col-md-4 mb-3 ms-auto me-0 ps-md-2">
                                <label for="mPaymentAmount">Payment Amount</label>
                                <input type="number" name="mPaymentAmount" id="mPaymentAmount"
                                    value="<?php if ($forEdit) {
                                        echo $payment['payment_amt'];
                                    } ?>" required
                                    class="form-control">
                            </div>
                        </div>

                        <div class="input-group">
                            <div class="col-12">
                                <label for="mComment">Comment</label>
                                <input type="text" name="mComment" id="mComment"
                                    value="<?php if ($forEdit) {
                                        echo $payment['comment'];
                                    } ?>" class="form-control">
                            </div>
                        </div>

                    <?php }
                    if (!$forEdit) { ?>
                        <div class="my-4">
                            <div class="table-responsive" style="<?php echo $tableHeight; ?>">
                                <table id="dataTable" class="table table-sm table-dark table-hover table-bordered">

                                    <thead style="color:var(--s-text-color);" class="mt-3">
                                        <th>#</th>
                                        <th>Invoice</th>
                                        <th>Payment Date</th>
                                        <th>Payment Amount</th>
                                        <th>Comment</th>
                                        <th style="width: 50px;">Action</th>
                                    </thead>
                                    <tbody class="text-center">
                                        <?php
                                        $sl = 1;
                                        if ($paymentDetails) {

                                            foreach ($paymentDetails as $row) { ?>
                                                <tr>
                                                    <td class="text-center"><?php echo $sl++ ?></td>
                                                    <td><?php echo InvoicePrefix::EVENT_PAY . $row['invoice'] ?></td>
                                                    <td><?php echo $row['payment_date'] ?></td>
                                                    <td><?php echo $row['payment_amt'] ?></td>
                                                    <td><?php echo $row['comment'] ?></td>
                                                    <td class="text-center">
                                                        <div class="btn-group">
                                                            <?php if (Permission()) { ?>
                                                                <button class="btn btn-sm action-btn"
                                                                    onclick="PaymentEditForm(<?php echo $row['id'] ?>)"><i
                                                                        class="bi bi-pencil-fill"></i></button>
                                                                <button class="btn btn-sm action-btn"
                                                                    onclick="PaymentDelete(<?php echo $row['id'] ?>)"><i
                                                                        class="bi bi-trash-fill"></i></button>
                                                            <?php } ?>
                                                            <a class="btn btn-sm action-btn"
                                                                href="../print/invoice.php?id=<?php echo $row['id'] ?>&eid=<?php echo $event['id']; ?>"
                                                                target="_blank" rel="noopener noreferrer">
                                                                <i class="bi bi-printer-fill"></i>
                                                            </a>
                                                        </div>
                                                    </td>
                                                </tr>

                                            <?php }
                                        } ?>

                                    </tbody>
                                </table>

                            </div>
                        </div>
                    <?php } ?>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    <?php if ($forEdit) { ?>
                        <button type="submit" name="payment" class="btn btn-primary"
                            onclick="UpdatePayment(<?php echo $payment['id']; ?>)">Update</button>
                    <?php } else {
                        if ($forPayment) { ?>
                            <button type="submit" name="payment" class="btn btn-primary" onclick="MakePayment()">Make
                                Payment</button>
                        <?php }
                    } ?>
                </div>
            </div>
            <!-- </form> -->
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        $('#paymentModal').on('shown.bs.modal', function () {
            $('#mPaymentAmount').trigger('focus');
        });
    });
</script>