<?php
$_main_root = '../';
require_once $_main_root . 'db/model.php';

$db = new Model();
if (isset($_POST['type'])) {
    
    if ($_POST['type'] == "list") {
        $list = $db->GetQuotation();
        header('Content-Type: application/json');
        echo json_encode($list);
    }
    exit;
}

?>

<div class="table-responsive">
    <table id="tableQuote" class="table table-sm table-dark table-hover table-bordered" style="width: 100%;">
        <thead style="color:var(--s-text-color);" class="mt-3">
            <th style="width: 50px;">#</th>
            <th style="">Client Name</th>
            <th style="">Purpose</th>
            <th style="">Amount</th>
            <th style="width: 5px;">Action</th>
        </thead>
        <tbody></tbody>
    </table>
</div>

<script>
    $(document).ready(function () {
        table = $('#tableQuote').DataTable({
            order: [],
            ajax: {
                url: 'cust_quotation_list_all.php',
                type: 'POST',
                data: {
                    type: 'list'
                },
                dataSrc: function (json) {
                    return json;
                },
            },
            columns: [
            {data: 'id'},
            {data: 'client_name'},
            {data: 'purpose'},
            {data: 'amount'},
            {
                data: null,
                render: function (data, type, row) {
                    var btn = '<div class="btn-group">';
                    btn += '<a href="cust_quotation.php?quote_id=' + row.id + '" class="btn btn-sm action-btn"><i class="bi bi-pencil-square"></i></a>';
                    btn += '<a href="../print/cust_quotation.php?quote_id=' + row.id + '" class="btn btn-sm action-btn"><i class="bi bi-printer-fill"></i></a>';
                    btn += '</div>';
                    return btn;
                }
            }
            ],
            columnDefs: [
                { targets: 0, className: 'dt-center' },
                { targets: 3, className: 'dt-center' },
                { targets: 4, className: 'dt-center' }
            ]
        });
    });
</script>