<?php
include('../db/model.php');
include('../config/config.php');
$db = new Model();

$event = null;
$addAnother = false;
$billNum = null;
$billDtlId = null;
$editBillDtl = null;
$addTime = null;
$outdoor = null;

if (isset($_POST['type'])) {

    if ($_POST['type'] == "find") {
        $eventId = $_POST['eventId'];
        $addAnother = $_POST['addAnother'] == "true";
        $billNum = $_POST['billNum'] ?? null;
        $event = $db->GetEventById($eventId);

        if (!$event) {
            header('Content-Type: application/json');
            echo json_encode(['event' => false]);
            exit;
        }

    }

    if ($_POST['type'] == "gbill") {
        $result = $db->GenerateBill($_POST);

        header('Content-Type: application/json');
        echo json_encode(['bill' => $result]);
        exit;
    }

    if ($_POST['type'] == "aaB") {
        $result = $db->AddUpdateEventInBill($_POST);

        header('Content-Type: application/json');
        echo json_encode(['bill' => $result]);
        exit;
    }

    if ($_POST['type'] == "edit") {
        $billDtlId = $_POST["id"];
        $editBillDtl = $db->GetBillDtlById($billDtlId);
        $event_id = $editBillDtl['event_id'];
        $event = $db->GetEventById($event_id);
        $outdoor = $db->GetEventOutdoor($event_id);
        $addTime = AdditionalTimeArr($editBillDtl['add_time'], true);
    }

    if ($_POST['type'] == "billDtlE") {
        $result = $db->EditDeleteBillDtl($_POST);

        header('Content-Type: application/json');
        echo json_encode(['flag' => $result]);
        exit;
    }

    if ($_POST['type'] == "delete") {
        $result = $db->EditDeleteBillDtl($_POST);

        header('Content-Type: application/json');
        echo json_encode(['flag' => $result]);
        exit;
    }
}

?>

<div class="modal fade" id="modalModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1"
    aria-labelledby="modalModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header text-center">
                <?php if ($addAnother) {
                    echo '<h1 class="modal-title w-100" id="modalModalLabel">ADD EVENT IN BILL (' . InvoicePrefix::BILL_NUMBER . $billNum . ')</h1>';
                } elseif ($editBillDtl) {
                    echo '<h1 class="modal-title w-100" id="modalModalLabel">EVENT DETAILS (' . InvoicePrefix::BILL_NUMBER . $editBillDtl['bill_num'] . ')</h1>';
                } else {
                    echo '<h1 class="modal-title w-100" id="modalModalLabel">EVENT DETAILS</h1>';
                } ?>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <div id="custom-form-dark">
                <div class="modal-body">
                    <input type="hidden" name="eventId" id="eventId"
                        value="<?php echo ($event) ? $event['id'] : ''; ?>">
                    <input type="hidden" name="hBillNum" id="hBillNum"
                        value="<?php echo ($editBillDtl) ? $editBillDtl['bill_num'] : ''; ?>">

                    <div class="row">
                        <div class="col-12 col-md-6 mb-3">
                            <label for="" class="form-label">Client's Name</label>
                            <input type="text" name="client_name" id="client_name" class="form-control" disabled
                                value="<?php echo ($event) ? $event['client_name'] : ''; ?>">
                        </div>
                        <div class="col-12 col-md-6 mb-3">
                            <label for="" class="form-label">Date / Time</label>
                            <input type="text" name="event_date_time" id="event_date_time" class="form-control" disabled
                                value="<?php echo ($event) ? sDate($event['event_date_time'], true, true) : ''; ?>">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12 col-md-4 mb-3">
                            <label for="" class="form-label">Email</label>
                            <input type="email" name="email" id="email" class="form-control" disabled
                                value="<?php echo ($event) ? $event['email'] : ''; ?>" placeholder="example@mail.com">
                        </div>
                        <div class="col-12 col-md-4 mb-3">
                            <label for="" class="form-label">Amount</label>
                            <input type="number" name="amount" id="amount" class="form-control text-center fw-bold"
                                disabled value="<?php echo ($event) ? $event['amount'] : ''; ?>">
                        </div>
                        <div class="col-12 col-md-4 mb-3">
                            <label for="" class="form-label">Adjustment</label>
                            <input type="number" name="adjustment" id="adjustment"
                                class="form-control text-center fw-bold"
                                value="<?php echo ($event) ? $event['adjustment'] : ''; ?>">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12 mb-3">
                            <div class="border border-2 border-success p-2">
                                <div class="row">
                                    <div class="col-12">
                                        <label for="" class="form-label">Additional Time</label>
                                        <div class="input-group border-bottom border-2 border-success pb-2">
                                            <input type="number" name="addHour" id="addHour"
                                                class="form-control text-center"
                                                value="<?= (is_array($addTime) && count($addTime) == 2) ? $addTime['hours'] : '' ?>"
                                                placeholder="Hour - default 1 hour">
                                            <input type="number" name="addHourAmt" id="addHourAmt"
                                                class="form-control text-center"
                                                value="<?= (is_array($addTime) && count($addTime)) ? $addTime['amount'] : '' ?>"
                                                placeholder="Amount">
                                        </div>
                                    </div>

                                </div>

                                <label for="" class="form-label mt-2">Outdoor <shakikul class="text-secondary">(Details, Location, Photographer, Cinemetographer, Drone, Amount)</shakikul></label>
                                <div class="input-group">
                                    <input type="text" name="outdoorDtl" id="outdoorDtl"
                                        class="form-control text-center"
                                        value="<?= ($outdoor) ? $outdoor['hours'] : '' ?>"
                                        placeholder="10:30 AM - 02:30 PM" title="Details/Time">

                                    <input type="text" name="outdoorVenue" id="outdoorVenue"
                                        class="form-control text-center"
                                        value="<?= ($outdoor) ? $outdoor['venue'] : '' ?>" placeholder="Location" title="Location">
                                </div>
                                <div class="input-group">
                                    <input type="number" name="outdoorPhoto" id="outdoorPhoto"
                                        class="form-control text-center"
                                        value="<?= ($outdoor) ? $outdoor['photog'] : '' ?>" placeholder="Photographer" title="Photographer">

                                    <input type="number" name="outdoorCinemeto" id="outdoorCinemeto"
                                        class="form-control text-center"
                                        value="<?= ($outdoor) ? $outdoor['cinemetog'] : '' ?>"
                                        placeholder="Cinemetographer" title="Cinemetographer">

                                    <input type="number" name="outdoorDrone" id="outdoorDrone" class="form-control text-center"
                                        value="<?= ($outdoor) ? $outdoor['drone'] : '' ?>" placeholder="Drone" title="Drone">

                                    <input type="number" name="outdoorAmt" id="outdoorAmt"
                                        class="form-control text-center"
                                        value="<?= ($outdoor) ? $outdoor['amt'] : '' ?>" placeholder="Amount" title="Amount">

                                </div>
                            </div>
                        </div>
                    </div>

                </div>
            </div>

            <div class="modal-footer bg-dark">
                <?php if ($editBillDtl) { ?>
                    <button type="button" class="btn btn-secondary"
                        onclick="updateBillDtl(<?= $billDtlId ?>)">Update</button>
                <?php } else { ?>
                    <button type="button" class="btn btn-secondary"
                        onclick="generateBill(<?= ($addAnother) ? $billNum : ''; ?>)">Add in Bill</button>
                <?php } ?>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        var modal = document.getElementById('modalModal');
        var addHour = document.getElementById('addHour');
        var addHourAmt = document.getElementById('addHourAmt');
        var outdoor = document.getElementById('outdoor');
        var outdoorAmt = document.getElementById('outdoorAmt');

        if (modal) {
            modal.addEventListener('shown.bs.modal', () => {
                if (addHour) {
                    addHour.focus();
                    addHour.select();
                }
            });
        }

        var input_fields = Array.from(document.querySelectorAll(".modal-body input:not([disabled])"));
        if (input_fields) {
            input_fields.forEach((field, index) => {
                field.addEventListener("keydown", function (e) {
                    if (e.key === "Enter") {
                        e.preventDefault();

                        if (index < input_fields.length - 1) {
                            var nextField = input_fields[index + 1];
                            nextField.focus();

                            if (nextField.tagName === "INPUT") {
                                nextField.select();
                            }
                        }
                    }
                });
            });
        }

        if (outdoorAmt) {
            outdoorAmt.addEventListener('keydown', (e) => {
                if (e.key === 'Enter') {
                    e.preventDefault();
                    <?php if ($editBillDtl) { ?>
                        updateBillDtl(<?= $billDtlId ?>);
                    <?php } else { ?>
                        generateBill(<?= $billNum ?>);
                    <?php } ?>
                }
            });
        }

    });

</script>