$(document).ready(function () {
  var sTableUserList = $('#sTableUserList').DataTable({
    order: [],
    ajax: {
      url: 'user_list.php',
      type: 'POST',
      data: {
        type: 'list'
      },
      dataSrc: function (json) {
        return json;
      },
    },
    columns: [
      { data: 'full_name' },
      { data: 'username' },
      { data: 'role_name' },
      {
        data: null,
        render: function (data, type, row) { 
          return `<div class="fw-bold ${row.status == '1' ? 'text-success' : 'text-danger'}">
          ${row.user_status}
          </div>`;
        }
      },
      {
        data: null,
        render: function (data, type, row) {
          return `<div class="btn-group">
          ${sAccess(se) ? `<button type="button" name="payment" class="btn btn-sm action-btn" onclick="UserDetail(${row.id})">
          <i class="bi bi-pencil-square"></i>` : ``}
          </button>
          </div>`;
        }
      }
    ],
    columnDefs: [
      { targets: 2, className: 'dt-center' },
      { targets: 3, className: 'dt-center' },
      { targets: 4, className: 'dt-center' },
    ]
  });
});

function UserDetail(id) {
  $.ajax({
    type: "post",
    url: "modal_user.php",
    data: {
      type: "form",
      id: id,
    },
    success: function (sData) {
      $("#userModalDiv").html("");
      $("#userModalDiv").append(sData);
      $("#userModal").modal("show");
    },
  });
}

function AddUser() {
  var userName = $("#mUserName").val();
  var fullName = $("#mFullName").val();
  var pass = $("#mPassword").val();
  var role = $("#role").val();
  var userStatus = document.getElementById('mUserStatusActive').checked ? 1 : 0;

  if (userName === "" || userName === null) {
    $("#mUserName").css("border-color", "red");
    return;
  }

  if (fullName === "" || fullName === null) {
    $("#mFullName").css("border-color", "red");
    return;
  }

  if (pass === null || pass === "") {
    $("#mPassword").css("border-color", "red");
    return;
  }

  $.ajax({
    type: "post",
    url: "modal_user.php",
    data: {
      type: "add",
      userName: userName,
      fullName: fullName,
      pass: pass,
      status: userStatus,
      role: role
    },
    success: function (sData) {
      $("#userModal").modal("hide");
      $("#sTableUserList").DataTable().ajax.reload();
    },
  });
}

function UpdateUser() {
  var id = $("#mId").val();
  var userName = $("#mUserName").val();
  var fullName = $("#mFullName").val();
  var pass = $("#mPassword").val();
  var role = $("#role").val();
  var userStatus = document.getElementById('mUserStatusActive').checked ? 1 : 0;

  if (userName === "" || userName === null) {
    $("#mUserName").css("border-color", "red");
    return;
  }

  if (fullName === "" || fullName === null) {
    $("#mFullName").css("border-color", "red");
    return;
  }

  if ((id === "" || id === null) && (pass === null || pass === "")) {
    $("#mPassword").css("border-color", "red");
    return;
  }

  swal({
    title: "Are you sure?",
    text: "Update this user!",
    icon: "warning",
    buttons: true,
    dangerMode: true,
  }).then((willDelete) => {
    if (willDelete) {
      $.ajax({
        type: "post",
        url: "modal_user.php",
        data: {
          type: "update",
          id: id,
          userName: userName,
          fullName: fullName,
          pass: pass,
          status: userStatus,
          role: role
        },
        success: function (sData) {
          $("#userModal").modal("hide");
          $("#sTableUserList").DataTable().ajax.reload();
          swal("Successfully updated!", {
            icon: "success",
          });
        },
      });
    }
  });
}
