<?php
session_start();

if (!isset($_login_page) || !$_login_page) {

	if (!isset($_SESSION['username'])) {
		header("Location: " . $_main_root . "index.php");
		exit();
	}
}

$_page_title = "Employee Ledger";
$_main_root = '../';
include($_main_root . "config/config.php");
include($_main_root . "db/model.php");
$obj = new Model();

$eventList = null;
$emp = null;

if (isset($_GET['ei'])) {
	$emp_id = $_GET['ei'];
	$fromDate = $_GET['f'];
	$toDate = $_GET['t'];

	$reportFor = $_GET['r'];

	if ($emp_id > 0) {
		$eventList = $obj->GetAssignedEventByEmpId($emp_id, $fromDate, $toDate);
		$emp = $obj->GetEmpById($emp_id);
	}
}


?>

<!DOCTYPE html>
<html>

<head>
	<!-- Required meta tags -->
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">

	<!-- Bootstrap CSS -->
	<link rel="stylesheet" href="<?php echo $_main_root; ?>style/bootstrap-5.3.0/css/bootstrap.min.css">

	<title><?php echo strtoupper($emp['full_name']) . '_' . $reportFor; ?></title>

	<style>
		body {
			font-family: 'Times New Roman', Times, serif;
		}

		.invoice-box {
			max-width: 900px;
			margin: auto;
			font-size: 16px;
			line-height: 24px;
			color: #000;
		}

		@media print {
			body * {
				visibility: hidden;
			}

			@page {
				size: A4 portrait;
				margin: 10mm;
			}

			.container_content,
			.container_content * {
				visibility: visible;
			}
		}
	</style>

</head>

<body>

	<div class="container_content">
		<div class="invoice-box">

			<!-- report header section -->
			<table class="w-100" style="background-color:#E6E6E6;">
				<tr>
					<td>
						<img src="snapmoment_logo.png" style="width: 100%; max-width: 300px; margin-top: 20px !important; margin-left: -22px !important; " />
					</td>
					<td style="text-align: right;">
						<h3 style="margin-top: 20px; margin-right: 15px;">BILL: <?php echo $reportFor; ?></h3><br /><br />
						<p style="margin-right: 15px; font-size:20px;">Print Date: <?php echo sDate(date("Y-m-d")) ?></p>
					</td>
				</tr>
			</table>

			<!-- company address and client contact -->
			<table class="my-3 w-100">
				<tr>
					<td>
						To ,<br />
						<h5>
							<strong><?php echo strtoupper($emp['full_name']); ?></strong><br />
							<?php echo $emp['designation']; ?> <br />
						</h5>
						Contact: <?php echo $emp['phone_number']; ?> <br />
						Email: <?php echo $emp['email']; ?>
					</td>

				</tr>
			</table>

			<div class="d-flex justify-content-between">
				<div class="">
					<strong>Bill Details:</strong>
				</div>
				<div class="">

				</div>
			</div>
			<table class="table table-bordered border-dark mt-1">
				<thead class="table-dark">
					<tr class="text-center" style="font-size: 15px;">
						<!-- <th>#</th> -->
						<!-- <th style="width:120px;">Assign Date</th> -->
						<th style="width:100px; padding: 3px;">Date</th>
						<th style="padding: 3px;">Details</th>
						<th style="width: 50px; padding: 3px;">Shift</th>
						<th style="width: 50px; padding: 3px;">Ex.Hour</th>
						<th style="width: 50px; padding: 3px;">Edit</th>
						<th style="width: 50px; padding: 3px;">Travel</th>
						<th style="width: 50px; padding: 3px;">Bill</th>
						<th style="width: 50px; padding: 3px;">Pay</th>
					</tr>
				</thead>
				<tbody id="ledgerTableBody">

					<?php $sl = 1;
					$bill = 0;
					$pay = 0;
					$countEvent = 0;
					$countPayment = 0;
					if ($eventList) {
						foreach ($eventList as $row) {
							$payableAmt = $row['payable_amt'];
							$payment = $row['payment'];
							$bill += $payableAmt;
							$pay += $payment;
							$countEvent += ($payableAmt > 0) ? 1 : 0;
							$countPayment += ($payment > 0) ? 1 : 0;
					?>
							<tr class="">
								<!-- <td style="padding: 0 5px 0 5px; text-align: center;"><?php echo $sl++ ?></td> -->
								<td style="padding: 0 5px 0 5px; text-align: center;"><?php echo sDate($row['date']); ?></td>

								<?php if ($row['payment'] > 0) { ?>
									<td style="padding: 0 5px 0 5px; text-align: left;" colspan="6"><?php echo $row['remarks']; ?></td>
								<?php } else { ?>
									<td style="padding: 0 5px 0 5px; text-align: left;"><?php echo $row['remarks']; ?></td>
									<td style="padding: 0 5px 0 5px; text-align: right;"><?php echo $row['shift_amt'] . "x" . $row['shift_count'] . "=" . $row['total_shift_amt']; ?></td>
									<td style="padding: 0 5px 0 5px; text-align: right;"><?php echo ($row['hour_count'] > 0) ? $row['hour_amt'] . "x" . $row['hour_count'] . "=" . $row['total_hour_amt'] : 0; ?></td>
									<td style="padding: 0 5px 0 5px; text-align: right;"><?php echo $row['edit_fee']; ?></td>
									<td style="padding: 0 5px 0 5px; text-align: right;"><?php echo $row['travel_cost']; ?></td>
									<td style="padding: 0 5px 0 5px; text-align: right;"><?php echo $row['payable_amt']; ?></td>
								<?php } ?>
								<td style="padding: 0 5px 0 5px; text-align: right;"><?php echo $row['payment']; ?></td>
							</tr>
					<?php }
					} ?>

					<tr>
						<td style="padding: 0 5px 0 5px; text-align: right;" class="mt-5 text-end fw-bold" colspan="6">
							<div class="d-flex justify-content-between">
								<div>
									<?php
										echo $countEvent . (($countEvent > 1) ? " Events" : " Event");
										echo " & ";
										echo $countPayment . (($countPayment > 1) ? " Payments" : " Payment");
									?>
								</div>
								<div>Total = </div>
							</div>
						</td>
						<td style="padding: 0 5px 0 5px; text-align: right;" class="mt-5 text-end fw-bold"><?php echo $bill; ?> </td>
						<td style="padding: 0 5px 0 5px; text-align: right;" class="mt-5 text-end fw-bold"><?php echo $pay; ?> </td>
					</tr>
					<td class="mt-5 text-center fw-bold fs-5" colspan="9">Payable This Month: <?php echo $bill - $pay . $amountSign; ?> </td>
				</tbody>
			</table>

			<!-- signature and paid logo -->

			<table class="w-100">
				<tr>
					<td>
						<img class="ms-4" src="raihan_signature.jpg" style="height: 110px;" />
					</td>
				</tr>
			</table>
		</div>
	</div>

	<div class="text-center" style="padding:20px;">
		<input type="button" value="Download" class="btn btn-success btn_print" onclick="print_summary()">
	</div>

	<script src="<?php echo $_main_root; ?>style/DataTables/jQuery-3.6.0/jquery-3.6.0.min.js"></script>
	<script src="<?php echo $_main_root; ?>style/bootstrap-5.3.0/js/bootstrap.bundle.min.js"></script>

	<script>
		$(document).ready(function() {
			window.print();
		});

		function print_summary() {
			window.print();
		}
	</script>

</body>

</html>