<?php

include 'db_connect.php';

class Model extends ConnModel
{
    public $InvoicePrefixEventPay = '#INV-';
    public $InvoicePrefixEmpPay = '#E-INV-';

    private function GenerateInvoice($tableName)
    {
        $invFrm = date('y') . date('m');

        $sql = "SELECT invoice FROM $tableName WHERE id IN ( SELECT MAX(`id`) FROM $tableName)";

        $result = $this->conn->query($sql);

        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
            $lastInv = $row['invoice'];
            if ($lastInv != '' || $lastInv != null || $lastInv != 0) {
                $invFiext = substr($lastInv, 0, 4);
                $lastNum = (int)substr($lastInv, strlen($invFrm));
                $nextNum = $lastNum + 1;
                if ($invFrm == $invFiext) {
                    return $invFiext . $nextNum;
                } else {
                    return $invFrm . '1';
                }
            } else {
                return $invFrm . '1';
            }
        } else {
            return $invFrm . '1';
        }
    }

    private function InsertLedger($data)
    {
        $emp_id = $data['emp_id'];
        $event_id = $data['event_id'];
        $pay_id = $data['pay_id'];
        $date = $data['date'];
        $remarks = $data['remarks'];
        $payable_amt = $data['payable_amt'];
        $payment = $data['payment'];
        $type = $data['type'];

        $sqlS = "SELECT IFNULL(balance,0) AS balance FROM employee_ledger WHERE emp_id = $emp_id AND create_at IN (SELECT MAX(create_at) FROM employee_ledger WHERE emp_id=$emp_id)";
        $result = $this->conn->query($sqlS);
        $balance = 0;
        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
            $amt = $row['balance'];
            $balance = $amt;
        }

        $balance += $payable_amt;
        $balance -= $payment;

        $sql = "INSERT INTO `employee_ledger` (`emp_id`,`event_id`, `pay_id`, `date`, `remarks`, `payable_amt`, `payment`, `balance`, `type`, `create_at`) ";
        $sql .= "VALUES ('$emp_id','$event_id','$pay_id','$date','$remarks', '$payable_amt', '$payment', '$balance','$type', current_timestamp())";

        return $this->conn->query($sql);
    }

    public function GetEmpLedgerByEmpId($data, $dateRange = false, $forPrint = false)
    {
        $emp_id = $data['emp_id'];
        $fromDate = $data['fromDate'];
        $toDate = $data['toDate'];

        $sql = "SELECT * FROM employee_ledger WHERE emp_id = $emp_id";
        if ($dateRange) {
            $sql .= " AND DATE(create_at) BETWEEN '$fromDate' AND '$toDate'";
        }

        $sql .= ($forPrint) ? " ORDER BY date" : " ORDER BY create_at";

        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $list[] = $row;
            }
            return $list;
        }
    }

    public function UpdateEmpLedger($data, $dateRange = false)
    {

        $emp_id = $data['emp_id'];
        $fromDate = $data['fromDate'];
        $toDate = $data['toDate'];

        $InvoicePrefix = $this->InvoicePrefixEmpPay;

        $sqlDel = "DELETE FROM employee_ledger WHERE emp_id = $emp_id ";
        if ($dateRange) {
            $sqlDel .= " AND DATE(create_at) BETWEEN '$fromDate' AND '$toDate'";
        }
        $delete = $this->conn->query($sqlDel);

        $sql = "SELECT s.* FROM(
        (SELECT ae.emp_id AS emp_id, ae.event_id AS event_id, 0 AS pay_id, DATE(vwe.event_date_time) AS date, 
        CAST(CONCAT(vwe.id, '-', vwe.event_type, ' (', vwe.package_type, ')') AS VARCHAR(255)) AS remarks, 
        ae.payable_amt AS payable_amt, 0 AS payment, 'E' AS type, ae.create_at AS create_at 
        FROM assign_employee AS ae 
        LEFT JOIN vw_booking_with_payment AS vwe ON ae.event_id=vwe.id
        WHERE ae.emp_id=$emp_id)
        UNION ALL
        (SELECT ep.emp_id AS emp_id, 0 AS event_id, ep.id AS pay_id, DATE(ep.pay_date) AS date, 
        CAST(CONCAT('Payment ($InvoicePrefix', ep.invoice, CASE WHEN ep.remarks='' THEN '' ELSE ' / ' END, ep.remarks, ')') AS VARCHAR(255)) AS remarks, 
        0 AS payable_amt, ep.amt AS payment, 'P' AS type, ep.create_at AS create_at 
        FROM employee_payment AS ep WHERE ep.emp_id=$emp_id)) AS s
        WHERE s.emp_id=$emp_id";

        if ($dateRange) {
            $sql .= " AND s.create_at BETWEEN '$fromDate' AND '$toDate'";
        }
        $sql .= " ORDER BY s.create_at ASC";


        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {

            $insertSqlValues = "";
            $balance = 0;

            while ($row = $result->fetch_assoc()) {
                $event_id = $row['event_id'];
                $pay_id = $row['pay_id'];
                $date = $row['date'];
                $remarks = $row['remarks'];
                $payable_amt = $row['payable_amt'];
                $payment = $row['payment'];
                $type = $row['type'];
                $create_at = $row['create_at'];

                $balance += $payable_amt;
                $balance -= $payment;

                if ($insertSqlValues == "") {
                    $insertSqlValues .= "('$emp_id','$event_id','$pay_id','$date','$remarks', '$payable_amt', '$payment', '$balance','$type', '$create_at')";
                } else {
                    $insertSqlValues .= ", ('$emp_id','$event_id','$pay_id','$date','$remarks', '$payable_amt', '$payment', '$balance','$type', '$create_at')";
                }
            }
            $insertSqlValues .= ";";
            $insertSql = "INSERT INTO `employee_ledger` (`emp_id`,`event_id`, `pay_id`, `date`, `remarks`, `payable_amt`, `payment`, `balance`, `type`, `create_at`) VALUES " . $insertSqlValues;

            return $this->conn->query($insertSql);
        }

        return $delete;
    }

    public function AddUser($user)
    {
        $sql = '';
        $userName = $user['userName'];
        $fullName = strtoupper($user['fullName']);
        $pass = password_hash($user['pass'], PASSWORD_DEFAULT);
        $desigCode = $user['desig'];
        $status = $user['status'];

        $sql = "INSERT INTO `users` (`id`,`username`, `password`, `full_name`, `desig_code`, `status`) ";
        $sql .= "VALUES (NULL,'$userName','$pass','$fullName','$desigCode','$status')";

        return $this->conn->query($sql);
    }

    public function UpdateUser($user)
    {
        $sql = '';
        $id = $user['id'];
        $userName = $user['userName'];
        $fullName = strtoupper($user['fullName']);
        $pass = password_hash($user['pass'], PASSWORD_DEFAULT);
        $desigCode = $user['desig'];
        $status = $user['status'];

        if ($id > 0 || $id != '') {
            $sql = "UPDATE `users` SET `full_name`='$fullName', `desig_code`='$desigCode', `status`='$status'";
            if ($user['pass'] != '') {
                $sql .= " , `password`='$pass' ";
            }
            $sql .= " WHERE `id` = $id AND `username`='$userName'";
        }

        return $this->conn->query($sql);
    }

    public function UpdateUserPassword($user)
    {
        $sql = '';
        $id = $user['id'];
        $pass = password_hash($user['newPassword'], PASSWORD_DEFAULT);

        if ($id > 0 && $id != '' && $id != null) {
            $sql = "UPDATE `users` SET `password`='$pass' WHERE `id` = $id";
        }

        return $this->conn->query($sql);
    }

    public function UpdateUserProfile($user)
    {
        $sql = '';
        $id = $user['id'];
        $fullName = strtoupper($user['fullName']);


        if ($id > 0 && $id != '' && $id != null) {
            $sql = "UPDATE `users` SET `full_name`='$fullName' WHERE `id` = $id";
        }

        return $this->conn->query($sql);
    }

    public function UserList()
    {
        $sql = "SELECT * FROM `users`";

        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function GetUserByUserName($userName)
    {
        $sql = "SELECT * FROM users WHERE username='$userName'";

        $result = $this->conn->query($sql);
        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
            return $row;
        }
    }

    public function GetUserById($id)
    {
        $sql = "SELECT * FROM users WHERE id= $id";

        $result = $this->conn->query($sql);
        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
            return $row;
        }
    }

    public function AddEmp($data)
    {
        $sql = '';
        $full_name = $data['fullName'];
        $email = strtolower($data['email']);
        $phone_number = $data['phoneNumber'];
        $address = $data['address'];
        $salary = $data['salary'];
        $desig_code = $data['desig'];
        $status = $data['status'];

        $sql = "INSERT INTO `employees` (`id`,`full_name`, `email`, `phone_number`, `address`, `salary`, `desig_code`, `status`) ";
        $sql .= "VALUES (NULL,'$full_name','$email','$phone_number','$address','$salary', '$desig_code','$status')";

        try {
            return $this->conn->query($sql);
        } catch (mysqli_sql_exception $e) {
            return $e->getMessage();
        }
    }

    public function UpdateEmp($data)
    {
        $sql = '';
        $id = $data['id'];
        $full_name = $data['fullName'];
        $email = strtolower($data['email']);
        $phone_number = $data['phoneNumber'];
        $address = $data['address'];
        $salary = $data['salary'];
        $desig_code = $data['desig'];
        $status = $data['status'];

        if ($id > 0 || $id != '') {
            $sql = "UPDATE `employees` SET `full_name`='$full_name', `email`='$email', `phone_number`='$phone_number', `address`='$address', `salary`='$salary', `desig_code`='$desig_code', `status`='$status' WHERE `id` = $id";
        }

        try {
            return $this->conn->query($sql);
        } catch (mysqli_sql_exception $e) {
            return $e->getMessage();
        }
    }

    public function EmployeeList($onlyActive = false)
    {
        $sql = "SELECT * FROM vw_employee";
        if ($onlyActive) {
            $sql .= " WHERE status=1";
        }
        $sql .= " ORDER BY status DESC";
        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function GetEmpById($id)
    {
        $sql = "SELECT * FROM vw_employee WHERE id= $id";

        $result = $this->conn->query($sql);
        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
            return $row;
        }
    }

    public function GetAssignedEmpByEventId($id)
    {
        $sql = "SELECT ae.*, vwe.full_name, vwe.phone_number, vwe.designation FROM assign_employee AS ae LEFT JOIN vw_employee AS vwe ON ae.emp_id=vwe.id WHERE ae.event_id = $id";

        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function GetAssignedEventByEmpId($emp_id, $firstDate, $lastDate)
    {
        $InvoicePrefix = $this->InvoicePrefixEmpPay;

        $sql = "SELECT s.* FROM(
            (SELECT ae.emp_id, ae.shift_amt, ae.shift_count, ae.total_shift_amt, ae.hour_amt, ae.hour_count, ae.total_hour_amt, ae.edit_fee, ae.travel_cost, ae.event_id AS event_id, 0 AS pay_id, DATE(vwe.event_date_time) AS date, 
            CAST(CONCAT(vwe.id, '-', vwe.event_type, ' (', vwe.package_type, ')') AS VARCHAR(255)) AS remarks, 
            ae.payable_amt AS payable_amt, 0 AS payment, 'E' AS type, ae.create_at AS create_at 
            FROM assign_employee AS ae 
            LEFT JOIN vw_booking_with_payment AS vwe ON ae.event_id=vwe.id
            WHERE ae.emp_id=$emp_id)
            UNION ALL
            (SELECT ep.emp_id, 0 AS shift_amt, 0 AS shift_count, 0 AS total_shift_amt, 0 AS hour_amt, 0 AS hour_count, 0 AS total_hour_amt, 0 AS edit_fee, 0 AS travel_cost, 0 AS event_id, ep.id AS pay_id, DATE(ep.pay_date) AS date, 
            CAST(CONCAT('Payment ($InvoicePrefix', ep.invoice, CASE WHEN ep.remarks='' THEN '' ELSE ' / ' END, ep.remarks, ')') AS VARCHAR(255)) AS remarks, 
            0 AS payable_amt, ep.amt AS payment, 'P' AS type, ep.create_at AS create_at 
            FROM employee_payment AS ep WHERE ep.emp_id=$emp_id)) AS s
            WHERE s.emp_id=$emp_id AND s.date BETWEEN '$firstDate' AND '$lastDate'
            ORDER BY s.date";

        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function GetAssignedEmpEvent()
    {
        $sql = "SELECT ae.event_id, vwe.event_date_time, vwe.event_type, vwe.package_type, vwe.location, COUNT(*) AS assi_emp_count
            FROM assign_employee AS ae
            LEFT JOIN vw_booking_with_payment AS vwe ON ae.event_id=vwe.id
            GROUP BY ae.event_id, vwe.event_date_time, vwe.event_type, vwe.package_type, vwe.location
            ORDER BY vwe.event_date_time DESC";

        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function DeleteAssignedEmployee($id, $event_id)
    {
        $sql1 = "SELECT emp_id, -(payable_amt) as payable_amt FROM assign_employee WHERE id=$id";

        $result = $this->conn->query($sql1);
        $row = null;
        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
        }
        $event = $this->GetEventById($event_id);

        $ledgerData = [
            'emp_id' => $row['emp_id'],
            'event_id' => $event_id,
            'pay_id' => '',
            'date' => $event['event_date_time'],
            'remarks' => 'Remove - ' . $event['event_type'] . ' (' . $event['package_type'] . ')',
            'payable_amt' => $row['payable_amt'],
            'payment' => 0,
            'type' => 'E'
        ];

        $sql = "DELETE FROM `assign_employee` WHERE `id`=$id";
        $delete = $this->conn->query($sql);

        $this->InsertLedger($ledgerData);
        return $delete;
    }

    public function EmpDesigList()
    {
        $sql = "SELECT * FROM `emp_designation`";

        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function AssignEmployee($data, $user_name)
    {
        $event_id = $data['eventId'];
        $emp_id = $data['empId'];
        $shift_amt = $data['shiftPayable'];
        $shift_count = $data['shiftCount'];
        $total_shift_amt = $data['totalShiftPayable'];
        $hour_amt = $data['hourPayable'];
        $hour_count = $data['totalHour'];
        $total_hour_amt = $data['extraHourPayable'];
        $edit_fee = $data['editingFee'];
        $travel_cost = $data['travelCost'];
        $payable_amt = $data['totalPayable'];

        $hour_amt = $total_hour_amt > 0 ? $hour_amt : 0;

        $sql = '';


        $sql = "INSERT INTO assign_employee (id, event_id, emp_id, shift_amt, shift_count, total_shift_amt,
        hour_amt, hour_count, total_hour_amt, edit_fee, travel_cost, payable_amt, create_by, create_at) 
        VALUES (NULL,'$event_id','$emp_id', '$shift_amt', '$shift_count', '$total_shift_amt', '$hour_amt', 
        '$hour_count', '$total_hour_amt', '$edit_fee', '$travel_cost', '$payable_amt', '$user_name', current_timestamp())";

        $insert = $this->conn->query($sql);

        $event = $this->GetEventById($event_id);

        $ledgerData = [
            'emp_id' => $emp_id,
            'event_id' => $event_id,
            'pay_id' => '',
            'date' => $event['event_date_time'],
            'remarks' => $event['id'] . '-' . $event['event_type'] . ' (' . $event['package_type'] . ')',
            'payable_amt' => $payable_amt,
            'payment' => 0,
            'type' => 'E',
        ];

        $this->InsertLedger($ledgerData);
        return $insert;
    }

    public function EmployeePayment($data, $user_name)
    {
        $emp_id = $data['empId'];
        $payDate = $data['payDate'];
        $remarks = $data['remarks'];
        $payment = $data['payment'];
        $invNumber = $this->GenerateInvoice("employee_payment");

        $sql = "INSERT INTO `employee_payment` (`id`, `invoice`, `pay_date`, `emp_id`, `amt`, `remarks`, `create_by`, `create_at`)";
        $sql .= " VALUES (NULL, '$invNumber', '$payDate', '$emp_id', $payment, '$remarks', ' $user_name', current_timestamp())";
        $this->conn->query($sql);
        $insertId = $this->conn->insert_id;

        $rem = ($remarks == "") ? "" : " / " . $remarks;

        $ledgerData = [
            'emp_id' => $emp_id,
            'event_id' => '',
            'pay_id' => $insertId,
            'date' => $payDate,
            'remarks' => 'Payment (' . $this->InvoicePrefixEmpPay . $invNumber . $rem . ')',
            'payable_amt' => 0,
            'payment' => $payment,
            'type' => 'P',
        ];

        //CAST(CONCAT('Payment ($InvoicePrefix', ep.invoice, CASE WHEN ep.remarks='' THEN '' ELSE ' / ' END, ep.remarks, ')') AS VARCHAR(255)) AS remarks, 

        $this->InsertLedger($ledgerData);
        return $insertId;
    }

    public function EmployeePaymentDelete($id)
    {
        $sql = "DELETE FROM `employee_payment` WHERE `id`=$id;";


        $emp_pay = $this->GetEmpPayById($id);

        $rem = ($emp_pay['remarks'] == "") ? "" : " / " . $emp_pay['remarks'];

        $ledgerData = [
            'emp_id' => $emp_pay['emp_id'],
            'event_id' => '',
            'pay_id' => $emp_pay['id'],
            'date' => (new DateTime())->format('Y-m-d H:i:s'),
            'remarks' => 'Delete-Payment (' . $this->InvoicePrefixEmpPay . $emp_pay['invoice'] . $rem . ')',
            'payable_amt' => 0,
            'payment' => -$emp_pay['amt'],
            'type' => 'P',
        ];

        $delete = $this->conn->query($sql);
        $this->InsertLedger($ledgerData);
        return $delete;
    }

    public function GetLastEmpPayByEmpId($id)
    {
        $sql = "SELECT e.*, v.full_name, v.designation, v.phone_number, v.email, v.due_amt
                FROM employee_payment AS e
                LEFT JOIN vw_employee AS v ON e.emp_id=v.id
                WHERE e.id IN(SELECT MAX(id) FROM employee_payment WHERE emp_id = $id)";

        $result = $this->conn->query($sql);
        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
            return $row;
        }
    }

    public function GetEmpPayById($id)
    {
        $sql = "SELECT e.*, v.full_name, v.designation, v.phone_number, v.email, v.due_amt
                FROM employee_payment AS e
                LEFT JOIN vw_employee AS v ON e.emp_id=v.id
                WHERE e.id = $id";

        $result = $this->conn->query($sql);
        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
            return $row;
        }
    }

    public function GetEmpPayByEmpId($id)
    {
        $sql = "SELECT * FROM `employee_payment` WHERE emp_id=$id ORDER BY id DESC";

        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function EventList($payCompleteList = false, $dueList = false)
    {
        $sql = "SELECT * FROM vw_booking_with_payment";

        if ($payCompleteList) {
            $sql .= " WHERE due_amount <= 0";
        } else if ($dueList) {
            $sql .= " WHERE due_amount > 0";
        }

        $sql .= " ORDER BY event_date_time DESC";

        $result = $this->conn->query($sql);
        
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function GetEventById($eventId, $forEventUpdate=false)
    {
        $sql = "SELECT * FROM `vw_booking_with_payment` WHERE id= $eventId ";

        if ($forEventUpdate) {
            $sql = "SELECT * FROM wp_tablesome_table_3209 WHERE id = $eventId";
        }

        $result = $this->conn->query($sql);
        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
            return $row;
        }
    }

    public function EventPayment($data, $user_name)
    {
        $booking_id = $data['booking_id'];
        $payment_amt = $data['payment_amt'];
        $comment = $data['comment'];
        $invNumber = $this->GenerateInvoice("payment_info");
        $sql = "INSERT INTO `payment_info` (`id`, `invoice`, `booking_id`, `payment_date`, `payment_amt`, `comment`, `update_by`)";
        $sql .= " VALUES (NULL, $invNumber, '$booking_id', current_timestamp(), '$payment_amt', ' $comment', '$user_name');";
        return $this->conn->query($sql);
    }

    public function Discount($data, $user_name)
    {
        $booking_id = $data['booking_id'];
        $discount_amt = $data['discount_amt'];

        $discCount = $this->conn->query("SELECT COUNT(*) AS `is_disc` FROM `payment_info` WHERE `invoice`=0 AND `booking_id`=$booking_id")->fetch_assoc();

        $sql = "";

        if ($discCount['is_disc'] == 1) {
            $sql = "UPDATE `payment_info` SET `payment_amt`=$discount_amt, `comment`='Update Discount', `update_by`='$user_name' WHERE `invoice`=0 AND `booking_id`=$booking_id";
        } else if ($discCount['is_disc'] > 1) {
            return 0;
        } else {
            $sql = "INSERT INTO `payment_info` (`id`, `invoice`, `booking_id`, `payment_date`, `payment_amt`, `comment`, `update_by`)";
            $sql .= " VALUES (NULL, 0, $booking_id, current_timestamp(), $discount_amt, 'Discount', '$user_name');";
        }

        if ($sql == "") {
            return 0;
        }
        return $this->conn->query($sql);
    }

    public function UpdateEventPayment($data, $user_name)
    {
        $payId = $data['payId'];
        $payment_amt = $data['payment_amt'];
        $comment = $data['comment'];

        $sql = "UPDATE `payment_info` SET `payment_date`=current_timestamp(), `payment_amt`='$payment_amt', `comment`= '$comment', `update_by`='$user_name' WHERE `id`=$payId;";

        return $this->conn->query($sql);
    }

    public function DeleteEventPayment($id)
    {
        $sql = "DELETE FROM `payment_info` WHERE `id`=$id;";
        return $this->conn->query($sql);
    }

    public function GetEventPaymentById($id)
    {
        $sql = "SELECT * FROM `payment_info` WHERE id= $id ";

        $result = $this->conn->query($sql);
        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
            return $row;
        }
    }

    public function EventPayListByEventId($eventId)
    {
        $sql = "SELECT * FROM `payment_info` WHERE `booking_id`=$eventId AND `invoice`>0 ORDER BY `payment_date` DESC;";
        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function LastEventPayByEventId($eventId)
    {
        $sql = "SELECT * FROM `payment_info` WHERE `id` IN (SELECT MAX(`id`) FROM `payment_info` WHERE `booking_id`=$eventId);";
        $result = $this->conn->query($sql);
        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
            return $row;
        }
    }

    private function ExportTableToSQL($tableName)
    {
        try {
            $sql = "";

            if ($tableName === 'v') {
                $result = $this->conn->query("SHOW CREATE VIEW `vw_booking_with_payment`");
                $row = $result->fetch_assoc();
                $sql .= $row['Create View'] . ";\n\n";
            } else {
                $result = $this->conn->query("SHOW CREATE TABLE `$tableName`");
                $row = $result->fetch_assoc();
                $sql .= $row['Create Table'] . ";\n\n";

                $result = $this->conn->query("SELECT * FROM `$tableName`");
                $columns = array();
                $values = array();

                while ($row = $result->fetch_assoc()) {
                    if (empty($columns)) {
                        $columns = array_keys($row);
                    }
                    $escapedValues = array_map([$this->conn, 'real_escape_string'], array_values($row));
                    $values[] = "('" . implode("', '", $escapedValues) . "')";
                }

                if (!empty($values)) {
                    $sql .= "INSERT INTO `$tableName` (`" . implode('`, `', $columns) . "`) VALUES " . implode(', ', $values) . ";\n";
                }
            }

            return $sql;
        } catch (Exception $exception) {
            //echo "Error exporting t! Maybe t dose't exist";
        }
    }

    public function DownloadSQL($tableName)
    {
        $sql = $this->exportTableToSQL($tableName);

        if ($sql) {
            header('Content-Type: application/sql');
            header('Content-Disposition: attachment; filename="' . $tableName . '_' . date('y') . date('m') . date('d') . '.sql"');
            echo $sql;
            exit();
        }
    }

    public function AddEventType($data)
    {
        $sql = '';
        $name = $data['name'];
        $status = $data['status'];

        $sql = "INSERT INTO `event_type` (`id`,`name`, `status`) ";
        $sql .= "VALUES (NULL,'$name','$status')";

        try {
            return $this->conn->query($sql);
        } catch (mysqli_sql_exception $e) {
            return $e->getMessage();
        }
    }

    public function EventTypeList($onlyActive = false)
    {
        $sql = "SELECT * FROM event_type";
        if ($onlyActive) {
            $sql .= " WHERE status=1";
        }
        $sql .= " ORDER BY status DESC";
        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function GetEventTypeById($id)
    {
        $sql = "SELECT * FROM event_type WHERE id= $id";

        $result = $this->conn->query($sql);
        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
            return $row;
        }
    }

    public function UpdateEventType($data)
    {
        $sql = '';
        $id = $data['id'];
        $name = $data['name'];
        $status = $data['status'];

        if ($id > 0 || $id != '') {
            $sql = "UPDATE `event_type` SET `name`='$name', `status`='$status' WHERE `id` = $id";
        }

        try {
            return $this->conn->query($sql);
        } catch (mysqli_sql_exception $e) {
            return $e->getMessage();
        }
    }

    public function AddPackage($data)
    {
        $sql = '';
        $name = $data['name'];
        $amt = $data['amount'];
        $status = $data['status'];

        $sql = "INSERT INTO `package` (`id`,`name`, `amt`, `status`) ";
        $sql .= "VALUES (NULL,'$name','$amt','$status')";

        try {
            return $this->conn->query($sql);
        } catch (mysqli_sql_exception $e) {
            return $e->getMessage();
        }
    }

    public function PackageList($onlyActive = false)
    {
        $sql = "SELECT p.*, IFNULL(d.discount_amt, 0) AS discount_amt, (IFNULL(p.amt,0)-IFNULL(d.discount_amt,0)) AS after_discount FROM package AS p 
        LEFT JOIN (SELECT * FROM package_discount WHERE id IN (SELECT MAX(id) FROM package_discount GROUP BY package_id) AND valid_from <= CURDATE() AND valid_until >= CURDATE()) AS d ON p.id = d.package_id";
        
        if ($onlyActive) {
            $sql .= " WHERE p.status=1";
        }
        $sql .= " ORDER BY p.id ASC";
        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function GetPackageById($id)
    {
        $sql = "SELECT * FROM package WHERE id= $id";

        $result = $this->conn->query($sql);
        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
            return $row;
        }
    }

    public function UpdatePackage($data)
    {
        $sql = '';
        $id = $data['id'];
        $name = $data['name'];
        $amt = $data['amount'];
        $status = $data['status'];

        if ($id > 0 || $id != '') {
            $sql = "UPDATE `package` SET `name`='$name', `amt`='$amt', `status`='$status' WHERE `id` = $id";
        }

        try {
            return $this->conn->query($sql);
        } catch (mysqli_sql_exception $e) {
            return $e->getMessage();
        }
    }

    public function AddPackageDetails($data)
    {
        $sql = '';
        $package_id = $data['package_id'];
        $title = $data['title'];
        $details = $data['details'];
        $status = $data['status'];

        $sql = "INSERT INTO `package_details` (`id`,`package_id`, `title`, `details`, `status`) ";
        $sql .= "VALUES (NULL,'$package_id','$title','$details','$status')";

        try {
            return $this->conn->query($sql);
        } catch (mysqli_sql_exception $e) {
            return $e->getMessage();
        }
    }

    public function PackageDetailsList($onlyActive = false)
    {
        $sql = "SELECT pd.*, p.name AS package_name  FROM package_details AS pd
        LEFT JOIN package AS p ON pd.package_id = p.id";
        
        if ($onlyActive) {
            $sql .= " WHERE pd.status=1";
        }
        $sql .= " ORDER BY pd.package_id ASC";
        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function PackageDetailsListByPackageId($id)
    {
        $sql = "SELECT * FROM package_details WHERE package_id='$id'";
        
        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function GetPackageDetailsById($id)
    {
        $sql = "SELECT * FROM package_details WHERE id= $id";

        $result = $this->conn->query($sql);
        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
            return $row;
        }
    }

    public function UpdatePackageDetails($data)
    {
        $sql = '';
        $id = $data['id'];
        $package_id = $data['package_id'];
        $title = $data['title'];
        $details = $data['details'];
        $status = $data['status'];

        if ($id > 0 || $id != '') {
            $sql = "UPDATE `package_details` SET `package_id`='$package_id', `title`='$title', `details`='$details', `status`='$status' WHERE `id` = $id";
        }

        try {
            return $this->conn->query($sql);
        } catch (mysqli_sql_exception $e) {
            return $e->getMessage();
        }
    }

    public function AddDiscount($data)
    {
        $sql = '';
        $package_id = $data['packageId'];
        $valid_from = $data['validFrom'];
        $valid_until = $data['validUntil'];
        $discount_amt = $data['discountAmount'];

        $sql = "INSERT INTO `package_discount` (`id`,`package_id`, `valid_from`, `valid_until`, `discount_amt`) ";
        $sql .= "VALUES (NULL,'$package_id','$valid_from','$valid_until', '$discount_amt')";

        try {
            return $this->conn->query($sql);
        } catch (mysqli_sql_exception $e) {
            return $e->getMessage();
        }
    }

    public function DiscountList()
    {
        $sql = "SELECT d.*, p.name AS package_name FROM package_discount AS d LEFT JOIN package AS p ON d.package_id=p.id";
        $sql .= " ORDER BY valid_until DESC";
        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function GetDiscountById($id)
    {
        $sql = "SELECT d.*, p.name AS package_name FROM package_discount AS d LEFT JOIN package AS p ON d.package_id=p.id";
        $sql .= " WHERE d.id= $id";

        $result = $this->conn->query($sql);
        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
            return $row;
        }
    }

    public function UpdateDiscount($data)
    {
        $sql = '';
        $id = $data['id'];
        $package_id = $data['packageId'];
        $valid_from = $data['validFrom'];
        $valid_until = $data['validUntil'];
        $discount_amt = $data['discountAmount'];

        if ($id > 0 || $id != '') {
            $sql = "UPDATE `package_discount` SET `package_id`='$package_id', `valid_from`='$valid_from', `valid_until`='$valid_until' 
            , `discount_amt`=$discount_amt WHERE `id` = $id";
        }

        try {
            return $this->conn->query($sql);
        } catch (mysqli_sql_exception $e) {
            return $e->getMessage();
        }
    }

    public function DeleteDiscount($id){
        $sql = "DELETE FROM `package_discount` WHERE `id`=$id;";
        return $this->conn->query($sql);
    }

    public function AddAddOns($data)
    {
        $sql = '';
        $name = $data['name'];
        $amt = $data['amount'];
        $status = $data['status'];

        $sql = "INSERT INTO `addons` (`id`,`name`, `amt`, `status`) ";
        $sql .= "VALUES (NULL,'$name','$amt','$status')";

        try {
            return $this->conn->query($sql);
        } catch (mysqli_sql_exception $e) {
            return $e->getMessage();
        }
    }

    public function AddOnsList($onlyActive = false)
    {
        $sql = "SELECT * FROM addons";
        
        if ($onlyActive) {
            $sql .= " WHERE status=1";
        }
        $sql .= " ORDER BY status DESC";
        $result = $this->conn->query($sql);
        if ($result->num_rows > 0) {
            while ($row = $result->fetch_assoc()) {
                $data[] = $row;
            }
            return $data;
        }
    }

    public function GetAddOnsById($id)
    {
        $sql = "SELECT * FROM addons WHERE id= $id";

        $result = $this->conn->query($sql);
        if ($result->num_rows == 1) {
            $row = $result->fetch_assoc();
            return $row;
        }
    }

    public function UpdateAddOns($data)
    {
        $sql = '';
        $id = $data['id'];
        $name = $data['name'];
        $amt = $data['amount'];
        $status = $data['status'];

        if ($id > 0 || $id != '') {
            $sql = "UPDATE `addons` SET `name`='$name', `amt`='$amt', `status`='$status' WHERE `id` = $id";
        }

        try {
            return $this->conn->query($sql);
        } catch (mysqli_sql_exception $e) {
            return $e->getMessage();
        }
    }
}
