<?php
include('../db/model.php');
include('manage.php');
$obj = new Model();

$event = null;

if (isset($_POST["type"])) {

    if ($_POST["type"]=="modal" && isset($_POST['id'])) {
        $id = (int)$_POST['id'];
        if (is_numeric($id) && $id > 0 && $id != '' && $id != null) {
            $event = $obj->GetEventById($id);
        }
    }

    if ($_POST["type"] == "assign") {
        try {
            if (session_status() == PHP_SESSION_NONE) {
                session_start();
            }
            $userName = $_SESSION['username'];

            $result = $obj->AssignEmployee($_POST, $userName);

            if ($result) {
                header('Content-Type: application/json');
                echo json_encode([
                    'result' => true,
                    'message' => 'Employees assigned successfully!'
                ]);
            } else {
                header('Content-Type: application/json');
                echo json_encode([
                    'result' => false,
                    'message' => 'Error: Could not assign employees.'
                ]);
            }
        } catch (Exception $ex) {
            if (strpos($ex->getMessage(), 'duplicate entry') !== false) {
                header('Content-Type: application/json');
                echo json_encode([
                    'result' => false,
                    'message' => 'Error: Duplicate entry detected. This employee is already assigned.'
                ]);
            } else {
                header('Content-Type: application/json');
                echo json_encode([
                    'result' => false,
                    'message' => 'An unexpected error occurred: ' . $ex->getMessage()
                ]);
            }
        }
        exit();
    }



    if (isset($_POST['id']) && isset($_POST['eventId'])) {
        if ($_POST["type"] == "delete") {
            $obj->DeleteAssignedEmployee($_POST['id'], $_POST['eventId']);
        }
        exit();
    }
}
?>

<div class="modal fade" id="modalModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="modalModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header text-center">
                <h1 class="modal-title fs-5 w-100" id="modalModalLabel">UPDATE EVENT DETAILS</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <div id="custom-form">
                <div class="modal-body">

                    <input type="hidden" name="eventId" id="eventId" value="<?php echo ($event) ? $event['id'] : ""; ?>">

                    

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>


<script>
    $(document).ready(function() {
        
    });
</script>