<?php
include('../db/model.php');
include('../config/config.php');
$obj = new Model();

$event = null;

if (isset($_POST["type"])) {

    if ($_POST["type"] == "modal" && isset($_POST['id'])) {
        $id = (int)$_POST['id'];
        if (is_numeric($id) && $id > 0 && $id != '' && $id != null) {
            $event = $obj->GetEventById($id, true);
        }
    }

    if ($_POST["type"] == "assign") {
        try {
            if (session_status() == PHP_SESSION_NONE) {
                session_start();
            }
            $userName = $_SESSION['username'];

            $result = $obj->AssignEmployee($_POST, $userName);

            if ($result) {
                header('Content-Type: application/json');
                echo json_encode([
                    'result' => true,
                    'message' => 'Employees assigned successfully!'
                ]);
            } else {
                header('Content-Type: application/json');
                echo json_encode([
                    'result' => false,
                    'message' => 'Error: Could not assign employees.'
                ]);
            }
        } catch (Exception $ex) {
            if (strpos($ex->getMessage(), 'duplicate entry') !== false) {
                header('Content-Type: application/json');
                echo json_encode([
                    'result' => false,
                    'message' => 'Error: Duplicate entry detected. This employee is already assigned.'
                ]);
            } else {
                header('Content-Type: application/json');
                echo json_encode([
                    'result' => false,
                    'message' => 'An unexpected error occurred: ' . $ex->getMessage()
                ]);
            }
        }
        exit();
    }

    if (isset($_POST['id']) && isset($_POST['eventId'])) {
        if ($_POST["type"] == "delete") {
            $obj->DeleteAssignedEmployee($_POST['id'], $_POST['eventId']);
        }
        exit();
    }
}
?>

<div class="modal fade" id="modalModal" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="modalModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header text-center">
                <h1 class="modal-title fs-5 w-100" id="modalModalLabel">UPDATE EVENT DETAILS</h1>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>

            <div id="custom-form">
                <div class="modal-body">

                    <input type="hidden" name="eventId" id="eventId" value="<?php echo ($event) ? $event['id'] : ""; ?>">

                    <div class="row mb-3">
                        <div class="col-12">
                            <label for="" class="form-label">Client Name</label>
                            <input type="text" name="client_name" id="client_name" class="form-control" value="<?php echo ($event) ? $event['column_2'] : ""; ?>">
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-12 col-md-6 mb-3">
                            <label for="" class="form-label">Contact No</label>
                            <input type="text" name="contact_no" id="contact_no" class="form-control" value="<?php echo ($event) ? $event['column_3'] : ""; ?>">
                        </div>
                        <div class="col-12 col-md-6">
                            <label for="" class="form-label">E-mail</label>
                            <input type="text" name="email" id="email" class="form-control" value="<?php echo ($event) ? $event['column_4'] : ""; ?>">
                        </div>
                    </div>

                    <div class="row mb-3">
                        <div class="col-12">
                            <label for="" class="form-label">Event Type</label>
                            <select id="eventType" class="form-control form-select" name="">
                                <option value="">Select Event Type</option>
                                <option value="Wedding" <?php echo ($event['column_5'] == "Wedding") ? "Selected" : ""; ?>>Wedding</option>
                                <option value="Reception" <?php echo ($event['column_5'] == "Reception") ? "Selected" : ""; ?>>Reception</option>
                                <option value="Engagement" <?php echo ($event['column_5'] == "Engagement") ? "Selected" : ""; ?>>Engagement</option>
                                <option value="Halud" <?php echo ($event['column_5'] == "Halud") ? "Selected" : ""; ?>>Halud</option>
                                <option value="Mehadi" <?php echo ($event['column_5'] == "Mehadi") ? "Selected" : ""; ?>>Mehadi</option>
                                <option value="Akhd" <?php echo ($event['column_5'] == "Akhd") ? "Selected" : ""; ?>>Akhd</option>
                                <option value="Anniversary" <?php echo ($event['column_5'] == "Anniversary") ? "Selected" : ""; ?>>Anniversary</option>
                                <option value="Rong Khela" <?php echo ($event['column_5'] == "Rong Khela") ? "Selected" : ""; ?>>Rong Khela</option>
                                <option value="Ashirbad" <?php echo ($event['column_5'] == "Ashirbad") ? "Selected" : ""; ?>>Ashirbad</option>
                                <option value="Birthday" <?php echo ($event['column_5'] == "Birthday") ? "Selected" : ""; ?>>Birthday</option>
                                <option value="Architectural" <?php echo ($event['column_5'] == "Architectural") ? "Selected" : ""; ?>>Architectural</option>
                                <option value="Corporate" <?php echo ($event['column_5'] == "Corporate") ? "Selected" : ""; ?>>Corporate</option>
                                <option value="Fashion & Lifetyle" <?php echo ($event['column_5'] == "Fashion & Lifetyle") ? "Selected" : ""; ?>>Fashion &amp; Lifetyle</option>
                            </select>
                        </div>
                    </div>

                    <div class="row conditional-field groom_name">
                        <div class="col-12 col-md-6 mb-3">
                            <label for="" class="form-label">Groom's Name</label>
                            <input type="text" name="groom_name" id="groom_name" class="form-control" value="<?php echo ($event) ? $event['column_6'] : ""; ?>">
                        </div>
                        <div class="col-12 col-md-6">
                            <label for="" class="form-label">Bride's Name</label>
                            <input type="text" name="bride_name" id="bride_name" class="form-control" value="<?php echo ($event) ? $event['column_7'] : ""; ?>">
                        </div>
                    </div>

                    <div class="row mb-3 conditional-field birthday_person">
                        <div class="col-12">
                            <label for="" class="form-label">Birthday Person's Name</label>
                            <input type="text" name="birthday_person" id="birthday_person" class="form-control" value="<?php echo ($event) ? $event['column_8'] : ""; ?>">
                        </div>
                    </div>

                    <div class="row mb-3 conditional-field organization_name">
                        <div class="col-12">
                            <label for="" class="form-label">Organization's Name</label>
                            <input type="text" name="organization_name" id="organization_name" class="form-control" value="<?php echo ($event) ? $event['column_9'] : ""; ?>">
                        </div>
                    </div>

                    <div class="row conditional-field packages_Field">
                        <?php $package = explode('; ', $event['column_10']); ?>
                        <div class="col-12 col-md-6 mb-3">
                            <label for="" class="form-label">Packages</label>
                            <input type="text" name="packages" id="packages" class="form-control" value="<?php echo $package[0]; ?>">
                        </div>
                        <div class="col-12 col-md-6">
                            <label for="" class="form-label">Amount</label>
                            <input type="text" name="packageAmount" id="packageAmount" class="form-control" value="<?php echo $package[1]; ?>">
                        </div>
                    </div>

                    <div class="row mb-3 conditional-field package_amount">
                        <div class="col-12">
                            <label for="" class="form-label">Package Amount</label>
                            <input type="text" name="package_amount" id="package_amount" class="form-control" value="<?php echo ($event) ? $event['column_15'] : ""; ?>">
                        </div>
                    </div>

                    <div class="row mb-3 conditional-field location_event_date_time">
                        <div class="col-12 col-md-6 mb-3">
                            <label for="" class="form-label">Location</label>
                            <input type="text" name="location" id="location" class="form-control" value="<?php echo ($event) ? $event['column_11'] : ""; ?>">
                        </div>
                        <div class="col-12 col-md-6">
                            <label for="" class="form-label">Event Date & Time</label>
                            <input type="datetime-local" name="event_date_time" id="event_date_time" class="form-control" value="<?php echo ($event) ? sDateFromMillisecond($event['column_12']) : ""; ?>">
                        </div>
                    </div>

                    <div class="row mb-3 conditional-field song_preference">
                        <div class="col-12">
                            <label for="" class="form-label">Song Preference</label>
                            <input type="text" name="song_preference" id="song_preference" class="form-control" value="<?php echo ($event) ? $event['column_16'] : ""; ?>">
                        </div>
                    </div>

                    <div class="row mb-3 conditional-field your_preference">
                        <?php
                        $yourPreference = explode(',', $event['column_13']);
                        ?>
                        <label for="" class="form-label">Your Preference</label>
                        <div class="col-12 col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value="Couple Photos" id="couplePhotos"
                                    <?php echo in_array('Couple Photos', $yourPreference) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="couplePhotos">
                                    Couple Photos
                                </label>
                            </div>

                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value="Candid Photos" id="candidPhotos"
                                    <?php echo in_array('Candid Photos', $yourPreference) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="candidPhotos">
                                    Candid Photos
                                </label>
                            </div>

                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value="Outdoor Photos" id="outdoorPhotos"
                                    <?php echo in_array('Outdoor Photos', $yourPreference) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="outdoorPhotos">
                                    Outdoor Photos
                                </label>
                            </div>
                        </div>
                        <div class="col-12 col-md-6">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value="Family Photos" id="familyPhotos"
                                    <?php echo in_array('Family Photos', $yourPreference) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="familyPhotos">
                                    Family Photos
                                </label>
                            </div>

                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value="Guest Photos" id="guestPhotos"
                                    <?php echo in_array('Guest Photos', $yourPreference) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="guestPhotos">
                                    Guest Photos
                                </label>
                            </div>

                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" value="Others" id="others"
                                    <?php echo in_array('Others', $yourPreference) ? 'checked' : ''; ?>>
                                <label class="form-check-label" for="others">
                                    Others
                                </label>
                            </div>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" onclick="updateEvent()">Update</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
    $(document).ready(function() {
        $('.conditional-field').hide();

        function conditional_form() {
            var eventType = $('#eventType').val();
            $('.conditional-field').hide();

            if (eventType === 'Fashion & Lifetyle') {
                $('.package_amount').show();
            } else if (eventType === 'Birthday') {
                $('.birthday_person, .packages_Field, .your_preference, .song_preference').show();
            } else if (eventType === 'Architectural' || eventType === 'Corporate') {
                $('.organization_name, .package_amount').show();
            } else if (
                eventType === 'Wedding' ||
                eventType === 'Reception' ||
                eventType === 'Engagement' ||
                eventType === 'Halud' ||
                eventType === 'Mehadi' ||
                eventType === 'Akhd' ||
                eventType === 'Anniversary' ||
                eventType === 'Rong Khela' ||
                eventType === 'Ashirbad'
            ) {
                $('.groom_name, .packages_Field, .your_preference, .song_preference').show();
            }

            $('.location_event_date_time').show();
        }

        $('#eventType').change(function() {
            conditional_form();
        });

        conditional_form();
    });
</script>