$(document).ready(function() {
        table = $('#dataTable').DataTable({
            order: [],
            ajax: {
                url: 'event_list_due.php',
                type: 'POST',
                data: {
                    type: 'eventList'
                },
                dataSrc: function(json) {
                    return json;
                },
            },
            columns: [{
                    data: null,
                    render: function(data) {
                        return sDate(data['booking_date_time']);
                    }
                },
                {
                    data: 'client_name'
                },
                {
                    data: 'phone'
                },
                {
                    data: 'event_type'
                },
                {
                    data: null,
                    render: function(data, type, row) {
                        var packageName = data['package_type'];
                        return packageName.substring(0, packageName.length - 2);
                    }
                },
                {
                    data: 'package_amount'
                },
                {
                    data: 'discount'
                },
                {
                    data: 'due_amount'
                },
                {
                    data: null,
                    render: function(data) {
                        return sDate(data['event_date_time']);
                    }
                },
                {
                    data: null,
                    render: function(data) {
                        return sTime(data['event_date_time']);
                    }
                },
                {
                    data: null,
                    render: function(data, type, row) {
                        var btn = '<div class="btn-group">';
                        btn += '<button type="button" name="payment" class="btn btn-sm action-btn" onclick="PaymentForm(' + row.id + ')">Payment</button>';
                        btn += '</div>';
                        return btn;
                    }
                }
            ]
        });
    });